<?php

namespace ColissimoPickupPoint\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findRDVPointRetraitAcheminement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminement $parameters
     * @return \ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementResponse|bool
     */
    public function findRDVPointRetraitAcheminement(\ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findRDVPointRetraitAcheminement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findRDVPointRetraitAcheminementByToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementByToken $parameters
     * @return \ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementByTokenResponse|bool
     */
    public function findRDVPointRetraitAcheminementByToken(\ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementByToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findRDVPointRetraitAcheminementByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findPointRetraitAcheminementByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ColissimoPickupPoint\StructType\FindPointRetraitAcheminementByID $parameters
     * @return \ColissimoPickupPoint\StructType\FindPointRetraitAcheminementByIDResponse|bool
     */
    public function findPointRetraitAcheminementByID(\ColissimoPickupPoint\StructType\FindPointRetraitAcheminementByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPointRetraitAcheminementByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ColissimoPickupPoint\StructType\FindPointRetraitAcheminementByIDResponse|\ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementByTokenResponse|\ColissimoPickupPoint\StructType\FindRDVPointRetraitAcheminementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
