<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockInfo StructType
 * @subpackage Structs
 */
class StockInfo extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Stock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Stock;
    /**
     * The ReservedStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReservedStock;
    /**
     * The LastMove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastMove;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleId;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * Constructor method for StockInfo
     * @uses StockInfo::setPrice()
     * @uses StockInfo::setStock()
     * @uses StockInfo::setReservedStock()
     * @uses StockInfo::setLastMove()
     * @uses StockInfo::setBranchId()
     * @uses StockInfo::setArticleId()
     * @uses StockInfo::setEAN()
     * @param float $price
     * @param float $stock
     * @param float $reservedStock
     * @param string $lastMove
     * @param string $branchId
     * @param string $articleId
     * @param string $eAN
     */
    public function __construct($price = null, $stock = null, $reservedStock = null, $lastMove = null, $branchId = null, $articleId = null, $eAN = null)
    {
        $this
            ->setPrice($price)
            ->setStock($stock)
            ->setReservedStock($reservedStock)
            ->setLastMove($lastMove)
            ->setBranchId($branchId)
            ->setArticleId($articleId)
            ->setEAN($eAN);
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\StockInfo
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Stock value
     * @return float
     */
    public function getStock()
    {
        return $this->Stock;
    }
    /**
     * Set Stock value
     * @param float $stock
     * @return \StructType\StockInfo
     */
    public function setStock($stock = null)
    {
        // validation for constraint: float
        if (!is_null($stock) && !(is_float($stock) || is_numeric($stock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stock, true), gettype($stock)), __LINE__);
        }
        $this->Stock = $stock;
        return $this;
    }
    /**
     * Get ReservedStock value
     * @return float
     */
    public function getReservedStock()
    {
        return $this->ReservedStock;
    }
    /**
     * Set ReservedStock value
     * @param float $reservedStock
     * @return \StructType\StockInfo
     */
    public function setReservedStock($reservedStock = null)
    {
        // validation for constraint: float
        if (!is_null($reservedStock) && !(is_float($reservedStock) || is_numeric($reservedStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservedStock, true), gettype($reservedStock)), __LINE__);
        }
        $this->ReservedStock = $reservedStock;
        return $this;
    }
    /**
     * Get LastMove value
     * @return string
     */
    public function getLastMove()
    {
        return $this->LastMove;
    }
    /**
     * Set LastMove value
     * @param string $lastMove
     * @return \StructType\StockInfo
     */
    public function setLastMove($lastMove = null)
    {
        // validation for constraint: string
        if (!is_null($lastMove) && !is_string($lastMove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMove, true), gettype($lastMove)), __LINE__);
        }
        $this->LastMove = $lastMove;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\StockInfo
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ArticleId value
     * @return string|null
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param string $articleId
     * @return \StructType\StockInfo
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: string
        if (!is_null($articleId) && !is_string($articleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\StockInfo
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
}
