<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendCustomerRequest StructType
 * @subpackage Structs
 */
class SendCustomerRequest extends AbstractStructBase
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The StandardDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StandardDiscount;
    /**
     * The IsReseller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsReseller;
    /**
     * The WithoutVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $WithoutVAT;
    /**
     * The AdvertisingAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AdvertisingAllowed;
    /**
     * The Blocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Blocked;
    /**
     * The BlockedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BlockedSinceDate;
    /**
     * The BonusPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BonusPoints;
    /**
     * The BonusSaleReduced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonusSaleReduced;
    /**
     * The BonusSaleRegular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonusSaleRegular;
    /**
     * The WithCharacteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $WithCharacteristics;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DefaultCurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultCurrencyISO;
    /**
     * The DefaultPaymentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultPaymentTypeId;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The CustomerCards
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerCard
     */
    public $CustomerCards;
    /**
     * The HomeBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomeBranchId;
    /**
     * The CreatedByEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByEmployee;
    /**
     * The CreatedAtPos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedAtPos;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentId;
    /**
     * The Characteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSendCustomerCharacteristic
     */
    public $Characteristics;
    /**
     * The PreferredCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreferredCommunication;
    /**
     * The VATId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VATId;
    /**
     * Constructor method for SendCustomerRequest
     * @uses SendCustomerRequest::setCreationDate()
     * @uses SendCustomerRequest::setStandardDiscount()
     * @uses SendCustomerRequest::setIsReseller()
     * @uses SendCustomerRequest::setWithoutVAT()
     * @uses SendCustomerRequest::setAdvertisingAllowed()
     * @uses SendCustomerRequest::setBlocked()
     * @uses SendCustomerRequest::setBlockedSinceDate()
     * @uses SendCustomerRequest::setBonusPoints()
     * @uses SendCustomerRequest::setBonusSaleReduced()
     * @uses SendCustomerRequest::setBonusSaleRegular()
     * @uses SendCustomerRequest::setWithCharacteristics()
     * @uses SendCustomerRequest::setShopId()
     * @uses SendCustomerRequest::setShopCustomerId()
     * @uses SendCustomerRequest::setCustomerId()
     * @uses SendCustomerRequest::setDescription()
     * @uses SendCustomerRequest::setDefaultCurrencyISO()
     * @uses SendCustomerRequest::setDefaultPaymentTypeId()
     * @uses SendCustomerRequest::setPerson()
     * @uses SendCustomerRequest::setCustomerCards()
     * @uses SendCustomerRequest::setHomeBranchId()
     * @uses SendCustomerRequest::setCreatedByEmployee()
     * @uses SendCustomerRequest::setCreatedAtPos()
     * @uses SendCustomerRequest::setParentId()
     * @uses SendCustomerRequest::setCharacteristics()
     * @uses SendCustomerRequest::setPreferredCommunication()
     * @uses SendCustomerRequest::setVATId()
     * @param string $creationDate
     * @param float $standardDiscount
     * @param bool $isReseller
     * @param bool $withoutVAT
     * @param bool $advertisingAllowed
     * @param bool $blocked
     * @param string $blockedSinceDate
     * @param int $bonusPoints
     * @param float $bonusSaleReduced
     * @param float $bonusSaleRegular
     * @param bool $withCharacteristics
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     * @param string $description
     * @param string $defaultCurrencyISO
     * @param string $defaultPaymentTypeId
     * @param \StructType\Person $person
     * @param \ArrayType\ArrayOfCustomerCard $customerCards
     * @param string $homeBranchId
     * @param string $createdByEmployee
     * @param string $createdAtPos
     * @param string $parentId
     * @param \ArrayType\ArrayOfSendCustomerCharacteristic $characteristics
     * @param string $preferredCommunication
     * @param string $vATId
     */
    public function __construct($creationDate = null, $standardDiscount = null, $isReseller = null, $withoutVAT = null, $advertisingAllowed = null, $blocked = null, $blockedSinceDate = null, $bonusPoints = null, $bonusSaleReduced = null, $bonusSaleRegular = null, $withCharacteristics = null, $shopId = null, $shopCustomerId = null, $customerId = null, $description = null, $defaultCurrencyISO = null, $defaultPaymentTypeId = null, \StructType\Person $person = null, \ArrayType\ArrayOfCustomerCard $customerCards = null, $homeBranchId = null, $createdByEmployee = null, $createdAtPos = null, $parentId = null, \ArrayType\ArrayOfSendCustomerCharacteristic $characteristics = null, $preferredCommunication = null, $vATId = null)
    {
        $this
            ->setCreationDate($creationDate)
            ->setStandardDiscount($standardDiscount)
            ->setIsReseller($isReseller)
            ->setWithoutVAT($withoutVAT)
            ->setAdvertisingAllowed($advertisingAllowed)
            ->setBlocked($blocked)
            ->setBlockedSinceDate($blockedSinceDate)
            ->setBonusPoints($bonusPoints)
            ->setBonusSaleReduced($bonusSaleReduced)
            ->setBonusSaleRegular($bonusSaleRegular)
            ->setWithCharacteristics($withCharacteristics)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId)
            ->setDescription($description)
            ->setDefaultCurrencyISO($defaultCurrencyISO)
            ->setDefaultPaymentTypeId($defaultPaymentTypeId)
            ->setPerson($person)
            ->setCustomerCards($customerCards)
            ->setHomeBranchId($homeBranchId)
            ->setCreatedByEmployee($createdByEmployee)
            ->setCreatedAtPos($createdAtPos)
            ->setParentId($parentId)
            ->setCharacteristics($characteristics)
            ->setPreferredCommunication($preferredCommunication)
            ->setVATId($vATId);
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\SendCustomerRequest
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get StandardDiscount value
     * @return float
     */
    public function getStandardDiscount()
    {
        return $this->StandardDiscount;
    }
    /**
     * Set StandardDiscount value
     * @param float $standardDiscount
     * @return \StructType\SendCustomerRequest
     */
    public function setStandardDiscount($standardDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($standardDiscount) && !(is_float($standardDiscount) || is_numeric($standardDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardDiscount, true), gettype($standardDiscount)), __LINE__);
        }
        $this->StandardDiscount = $standardDiscount;
        return $this;
    }
    /**
     * Get IsReseller value
     * @return bool
     */
    public function getIsReseller()
    {
        return $this->IsReseller;
    }
    /**
     * Set IsReseller value
     * @param bool $isReseller
     * @return \StructType\SendCustomerRequest
     */
    public function setIsReseller($isReseller = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReseller) && !is_bool($isReseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReseller, true), gettype($isReseller)), __LINE__);
        }
        $this->IsReseller = $isReseller;
        return $this;
    }
    /**
     * Get WithoutVAT value
     * @return bool
     */
    public function getWithoutVAT()
    {
        return $this->WithoutVAT;
    }
    /**
     * Set WithoutVAT value
     * @param bool $withoutVAT
     * @return \StructType\SendCustomerRequest
     */
    public function setWithoutVAT($withoutVAT = null)
    {
        // validation for constraint: boolean
        if (!is_null($withoutVAT) && !is_bool($withoutVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutVAT, true), gettype($withoutVAT)), __LINE__);
        }
        $this->WithoutVAT = $withoutVAT;
        return $this;
    }
    /**
     * Get AdvertisingAllowed value
     * @return bool
     */
    public function getAdvertisingAllowed()
    {
        return $this->AdvertisingAllowed;
    }
    /**
     * Set AdvertisingAllowed value
     * @param bool $advertisingAllowed
     * @return \StructType\SendCustomerRequest
     */
    public function setAdvertisingAllowed($advertisingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($advertisingAllowed) && !is_bool($advertisingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advertisingAllowed, true), gettype($advertisingAllowed)), __LINE__);
        }
        $this->AdvertisingAllowed = $advertisingAllowed;
        return $this;
    }
    /**
     * Get Blocked value
     * @return bool
     */
    public function getBlocked()
    {
        return $this->Blocked;
    }
    /**
     * Set Blocked value
     * @param bool $blocked
     * @return \StructType\SendCustomerRequest
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($blocked) && !is_bool($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        $this->Blocked = $blocked;
        return $this;
    }
    /**
     * Get BlockedSinceDate value
     * @return string
     */
    public function getBlockedSinceDate()
    {
        return $this->BlockedSinceDate;
    }
    /**
     * Set BlockedSinceDate value
     * @param string $blockedSinceDate
     * @return \StructType\SendCustomerRequest
     */
    public function setBlockedSinceDate($blockedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($blockedSinceDate) && !is_string($blockedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockedSinceDate, true), gettype($blockedSinceDate)), __LINE__);
        }
        $this->BlockedSinceDate = $blockedSinceDate;
        return $this;
    }
    /**
     * Get BonusPoints value
     * @return int
     */
    public function getBonusPoints()
    {
        return $this->BonusPoints;
    }
    /**
     * Set BonusPoints value
     * @param int $bonusPoints
     * @return \StructType\SendCustomerRequest
     */
    public function setBonusPoints($bonusPoints = null)
    {
        // validation for constraint: int
        if (!is_null($bonusPoints) && !(is_int($bonusPoints) || ctype_digit($bonusPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusPoints, true), gettype($bonusPoints)), __LINE__);
        }
        $this->BonusPoints = $bonusPoints;
        return $this;
    }
    /**
     * Get BonusSaleReduced value
     * @return float
     */
    public function getBonusSaleReduced()
    {
        return $this->BonusSaleReduced;
    }
    /**
     * Set BonusSaleReduced value
     * @param float $bonusSaleReduced
     * @return \StructType\SendCustomerRequest
     */
    public function setBonusSaleReduced($bonusSaleReduced = null)
    {
        // validation for constraint: float
        if (!is_null($bonusSaleReduced) && !(is_float($bonusSaleReduced) || is_numeric($bonusSaleReduced))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusSaleReduced, true), gettype($bonusSaleReduced)), __LINE__);
        }
        $this->BonusSaleReduced = $bonusSaleReduced;
        return $this;
    }
    /**
     * Get BonusSaleRegular value
     * @return float
     */
    public function getBonusSaleRegular()
    {
        return $this->BonusSaleRegular;
    }
    /**
     * Set BonusSaleRegular value
     * @param float $bonusSaleRegular
     * @return \StructType\SendCustomerRequest
     */
    public function setBonusSaleRegular($bonusSaleRegular = null)
    {
        // validation for constraint: float
        if (!is_null($bonusSaleRegular) && !(is_float($bonusSaleRegular) || is_numeric($bonusSaleRegular))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusSaleRegular, true), gettype($bonusSaleRegular)), __LINE__);
        }
        $this->BonusSaleRegular = $bonusSaleRegular;
        return $this;
    }
    /**
     * Get WithCharacteristics value
     * @return bool
     */
    public function getWithCharacteristics()
    {
        return $this->WithCharacteristics;
    }
    /**
     * Set WithCharacteristics value
     * @param bool $withCharacteristics
     * @return \StructType\SendCustomerRequest
     */
    public function setWithCharacteristics($withCharacteristics = null)
    {
        // validation for constraint: boolean
        if (!is_null($withCharacteristics) && !is_bool($withCharacteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withCharacteristics, true), gettype($withCharacteristics)), __LINE__);
        }
        $this->WithCharacteristics = $withCharacteristics;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\SendCustomerRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\SendCustomerRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendCustomerRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SendCustomerRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DefaultCurrencyISO value
     * @return string|null
     */
    public function getDefaultCurrencyISO()
    {
        return $this->DefaultCurrencyISO;
    }
    /**
     * Set DefaultCurrencyISO value
     * @param string $defaultCurrencyISO
     * @return \StructType\SendCustomerRequest
     */
    public function setDefaultCurrencyISO($defaultCurrencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCurrencyISO) && !is_string($defaultCurrencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCurrencyISO, true), gettype($defaultCurrencyISO)), __LINE__);
        }
        $this->DefaultCurrencyISO = $defaultCurrencyISO;
        return $this;
    }
    /**
     * Get DefaultPaymentTypeId value
     * @return string|null
     */
    public function getDefaultPaymentTypeId()
    {
        return $this->DefaultPaymentTypeId;
    }
    /**
     * Set DefaultPaymentTypeId value
     * @param string $defaultPaymentTypeId
     * @return \StructType\SendCustomerRequest
     */
    public function setDefaultPaymentTypeId($defaultPaymentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPaymentTypeId) && !is_string($defaultPaymentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPaymentTypeId, true), gettype($defaultPaymentTypeId)), __LINE__);
        }
        $this->DefaultPaymentTypeId = $defaultPaymentTypeId;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\SendCustomerRequest
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get CustomerCards value
     * @return \ArrayType\ArrayOfCustomerCard|null
     */
    public function getCustomerCards()
    {
        return $this->CustomerCards;
    }
    /**
     * Set CustomerCards value
     * @param \ArrayType\ArrayOfCustomerCard $customerCards
     * @return \StructType\SendCustomerRequest
     */
    public function setCustomerCards(\ArrayType\ArrayOfCustomerCard $customerCards = null)
    {
        $this->CustomerCards = $customerCards;
        return $this;
    }
    /**
     * Get HomeBranchId value
     * @return string|null
     */
    public function getHomeBranchId()
    {
        return $this->HomeBranchId;
    }
    /**
     * Set HomeBranchId value
     * @param string $homeBranchId
     * @return \StructType\SendCustomerRequest
     */
    public function setHomeBranchId($homeBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($homeBranchId) && !is_string($homeBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeBranchId, true), gettype($homeBranchId)), __LINE__);
        }
        $this->HomeBranchId = $homeBranchId;
        return $this;
    }
    /**
     * Get CreatedByEmployee value
     * @return string|null
     */
    public function getCreatedByEmployee()
    {
        return $this->CreatedByEmployee;
    }
    /**
     * Set CreatedByEmployee value
     * @param string $createdByEmployee
     * @return \StructType\SendCustomerRequest
     */
    public function setCreatedByEmployee($createdByEmployee = null)
    {
        // validation for constraint: string
        if (!is_null($createdByEmployee) && !is_string($createdByEmployee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByEmployee, true), gettype($createdByEmployee)), __LINE__);
        }
        $this->CreatedByEmployee = $createdByEmployee;
        return $this;
    }
    /**
     * Get CreatedAtPos value
     * @return string|null
     */
    public function getCreatedAtPos()
    {
        return $this->CreatedAtPos;
    }
    /**
     * Set CreatedAtPos value
     * @param string $createdAtPos
     * @return \StructType\SendCustomerRequest
     */
    public function setCreatedAtPos($createdAtPos = null)
    {
        // validation for constraint: string
        if (!is_null($createdAtPos) && !is_string($createdAtPos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAtPos, true), gettype($createdAtPos)), __LINE__);
        }
        $this->CreatedAtPos = $createdAtPos;
        return $this;
    }
    /**
     * Get ParentId value
     * @return string|null
     */
    public function getParentId()
    {
        return $this->ParentId;
    }
    /**
     * Set ParentId value
     * @param string $parentId
     * @return \StructType\SendCustomerRequest
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        $this->ParentId = $parentId;
        return $this;
    }
    /**
     * Get Characteristics value
     * @return \ArrayType\ArrayOfSendCustomerCharacteristic|null
     */
    public function getCharacteristics()
    {
        return $this->Characteristics;
    }
    /**
     * Set Characteristics value
     * @param \ArrayType\ArrayOfSendCustomerCharacteristic $characteristics
     * @return \StructType\SendCustomerRequest
     */
    public function setCharacteristics(\ArrayType\ArrayOfSendCustomerCharacteristic $characteristics = null)
    {
        $this->Characteristics = $characteristics;
        return $this;
    }
    /**
     * Get PreferredCommunication value
     * @return string|null
     */
    public function getPreferredCommunication()
    {
        return $this->PreferredCommunication;
    }
    /**
     * Set PreferredCommunication value
     * @param string $preferredCommunication
     * @return \StructType\SendCustomerRequest
     */
    public function setPreferredCommunication($preferredCommunication = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCommunication) && !is_string($preferredCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCommunication, true), gettype($preferredCommunication)), __LINE__);
        }
        $this->PreferredCommunication = $preferredCommunication;
        return $this;
    }
    /**
     * Get VATId value
     * @return string|null
     */
    public function getVATId()
    {
        return $this->VATId;
    }
    /**
     * Set VATId value
     * @param string $vATId
     * @return \StructType\SendCustomerRequest
     */
    public function setVATId($vATId = null)
    {
        // validation for constraint: string
        if (!is_null($vATId) && !is_string($vATId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vATId, true), gettype($vATId)), __LINE__);
        }
        $this->VATId = $vATId;
        return $this;
    }
}
