<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IbtCreatorResponse StructType
 * @subpackage Structs
 */
class IbtCreatorResponse extends BaseCreatorResponse
{
    /**
     * The PostCreationActionPerformed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PostCreationActionPerformed;
    /**
     * The PostCreationActionSuccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PostCreationActionSuccess;
    /**
     * The Ibt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterBranchTransferHead
     */
    public $Ibt;
    /**
     * The PostCreationActionMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCreationActionMessage;
    /**
     * Constructor method for IbtCreatorResponse
     * @uses IbtCreatorResponse::setPostCreationActionPerformed()
     * @uses IbtCreatorResponse::setPostCreationActionSuccess()
     * @uses IbtCreatorResponse::setIbt()
     * @uses IbtCreatorResponse::setPostCreationActionMessage()
     * @param string $postCreationActionPerformed
     * @param bool $postCreationActionSuccess
     * @param \StructType\InterBranchTransferHead $ibt
     * @param string $postCreationActionMessage
     */
    public function __construct($postCreationActionPerformed = null, $postCreationActionSuccess = null, \StructType\InterBranchTransferHead $ibt = null, $postCreationActionMessage = null)
    {
        $this
            ->setPostCreationActionPerformed($postCreationActionPerformed)
            ->setPostCreationActionSuccess($postCreationActionSuccess)
            ->setIbt($ibt)
            ->setPostCreationActionMessage($postCreationActionMessage);
    }
    /**
     * Get PostCreationActionPerformed value
     * @return string
     */
    public function getPostCreationActionPerformed()
    {
        return $this->PostCreationActionPerformed;
    }
    /**
     * Set PostCreationActionPerformed value
     * @uses \EnumType\OnIbtAction::valueIsValid()
     * @uses \EnumType\OnIbtAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postCreationActionPerformed
     * @return \StructType\IbtCreatorResponse
     */
    public function setPostCreationActionPerformed($postCreationActionPerformed = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OnIbtAction::valueIsValid($postCreationActionPerformed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OnIbtAction', is_array($postCreationActionPerformed) ? implode(', ', $postCreationActionPerformed) : var_export($postCreationActionPerformed, true), implode(', ', \EnumType\OnIbtAction::getValidValues())), __LINE__);
        }
        $this->PostCreationActionPerformed = $postCreationActionPerformed;
        return $this;
    }
    /**
     * Get PostCreationActionSuccess value
     * @return bool
     */
    public function getPostCreationActionSuccess()
    {
        return $this->PostCreationActionSuccess;
    }
    /**
     * Set PostCreationActionSuccess value
     * @param bool $postCreationActionSuccess
     * @return \StructType\IbtCreatorResponse
     */
    public function setPostCreationActionSuccess($postCreationActionSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($postCreationActionSuccess) && !is_bool($postCreationActionSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($postCreationActionSuccess, true), gettype($postCreationActionSuccess)), __LINE__);
        }
        $this->PostCreationActionSuccess = $postCreationActionSuccess;
        return $this;
    }
    /**
     * Get Ibt value
     * @return \StructType\InterBranchTransferHead|null
     */
    public function getIbt()
    {
        return $this->Ibt;
    }
    /**
     * Set Ibt value
     * @param \StructType\InterBranchTransferHead $ibt
     * @return \StructType\IbtCreatorResponse
     */
    public function setIbt(\StructType\InterBranchTransferHead $ibt = null)
    {
        $this->Ibt = $ibt;
        return $this;
    }
    /**
     * Get PostCreationActionMessage value
     * @return string|null
     */
    public function getPostCreationActionMessage()
    {
        return $this->PostCreationActionMessage;
    }
    /**
     * Set PostCreationActionMessage value
     * @param string $postCreationActionMessage
     * @return \StructType\IbtCreatorResponse
     */
    public function setPostCreationActionMessage($postCreationActionMessage = null)
    {
        // validation for constraint: string
        if (!is_null($postCreationActionMessage) && !is_string($postCreationActionMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCreationActionMessage, true), gettype($postCreationActionMessage)), __LINE__);
        }
        $this->PostCreationActionMessage = $postCreationActionMessage;
        return $this;
    }
}
