<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discount StructType
 * @subpackage Structs
 */
class Discount extends AbstractStructBase
{
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Percent;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The Line
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The DiscountReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountReasonId;
    /**
     * Constructor method for Discount
     * @uses Discount::setPercent()
     * @uses Discount::setValue()
     * @uses Discount::setLine()
     * @uses Discount::setCurrencyISO()
     * @uses Discount::setDiscountReasonId()
     * @param float $percent
     * @param float $value
     * @param string $line
     * @param string $currencyISO
     * @param string $discountReasonId
     */
    public function __construct($percent = null, $value = null, $line = null, $currencyISO = null, $discountReasonId = null)
    {
        $this
            ->setPercent($percent)
            ->setValue($value)
            ->setLine($line)
            ->setCurrencyISO($currencyISO)
            ->setDiscountReasonId($discountReasonId);
    }
    /**
     * Get Percent value
     * @return float
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\Discount
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Discount
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Line value
     * @return string|null
     */
    public function getLine()
    {
        return $this->Line;
    }
    /**
     * Set Line value
     * @param string $line
     * @return \StructType\Discount
     */
    public function setLine($line = null)
    {
        // validation for constraint: string
        if (!is_null($line) && !is_string($line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->Line = $line;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\Discount
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get DiscountReasonId value
     * @return string|null
     */
    public function getDiscountReasonId()
    {
        return $this->DiscountReasonId;
    }
    /**
     * Set DiscountReasonId value
     * @param string $discountReasonId
     * @return \StructType\Discount
     */
    public function setDiscountReasonId($discountReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($discountReasonId) && !is_string($discountReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountReasonId, true), gettype($discountReasonId)), __LINE__);
        }
        $this->DiscountReasonId = $discountReasonId;
        return $this;
    }
}
