<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * @subpackage Structs
 */
class Country extends BaseContract_Oid
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CountryISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryISO;
    /**
     * Constructor method for Country
     * @uses Country::setDescription()
     * @uses Country::setCountryISO()
     * @param string $description
     * @param string $countryISO
     */
    public function __construct($description = null, $countryISO = null)
    {
        $this
            ->setDescription($description)
            ->setCountryISO($countryISO);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Country
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CountryISO value
     * @return string|null
     */
    public function getCountryISO()
    {
        return $this->CountryISO;
    }
    /**
     * Set CountryISO value
     * @param string $countryISO
     * @return \StructType\Country
     */
    public function setCountryISO($countryISO = null)
    {
        // validation for constraint: string
        if (!is_null($countryISO) && !is_string($countryISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryISO, true), gettype($countryISO)), __LINE__);
        }
        $this->CountryISO = $countryISO;
        return $this;
    }
}
