<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Characteristic StructType
 * @subpackage Structs
 */
class Characteristic extends BaseContract_Oid
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Fraction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Fraction;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpiryDate;
    /**
     * The DaysLeft
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DaysLeft;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CharacteristicType
     */
    public $Type;
    /**
     * Constructor method for Characteristic
     * @uses Characteristic::setID()
     * @uses Characteristic::setFraction()
     * @uses Characteristic::setExpiryDate()
     * @uses Characteristic::setDaysLeft()
     * @uses Characteristic::setDescription()
     * @uses Characteristic::setType()
     * @param int $iD
     * @param float $fraction
     * @param string $expiryDate
     * @param int $daysLeft
     * @param string $description
     * @param \StructType\CharacteristicType $type
     */
    public function __construct($iD = null, $fraction = null, $expiryDate = null, $daysLeft = null, $description = null, \StructType\CharacteristicType $type = null)
    {
        $this
            ->setID($iD)
            ->setFraction($fraction)
            ->setExpiryDate($expiryDate)
            ->setDaysLeft($daysLeft)
            ->setDescription($description)
            ->setType($type);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Characteristic
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Fraction value
     * @return float
     */
    public function getFraction()
    {
        return $this->Fraction;
    }
    /**
     * Set Fraction value
     * @param float $fraction
     * @return \StructType\Characteristic
     */
    public function setFraction($fraction = null)
    {
        // validation for constraint: float
        if (!is_null($fraction) && !(is_float($fraction) || is_numeric($fraction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fraction, true), gettype($fraction)), __LINE__);
        }
        $this->Fraction = $fraction;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\Characteristic
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get DaysLeft value
     * @return int
     */
    public function getDaysLeft()
    {
        return $this->DaysLeft;
    }
    /**
     * Set DaysLeft value
     * @param int $daysLeft
     * @return \StructType\Characteristic
     */
    public function setDaysLeft($daysLeft = null)
    {
        // validation for constraint: int
        if (!is_null($daysLeft) && !(is_int($daysLeft) || ctype_digit($daysLeft))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysLeft, true), gettype($daysLeft)), __LINE__);
        }
        $this->DaysLeft = $daysLeft;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Characteristic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\CharacteristicType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\CharacteristicType $type
     * @return \StructType\Characteristic
     */
    public function setType(\StructType\CharacteristicType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
}
