<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateIbt
     * Meta information extracted from the WSDL
     * - documentation: Updates the IBT with the quantities sent.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateIbt $parameters
     * @return \StructType\UpdateIbtResponse|bool
     */
    public function UpdateIbt(\StructType\UpdateIbt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateIbt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateIbtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
