<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAdditionalCostDefinitions
     * Meta information extracted from the WSDL
     * - documentation: Gets current AdditionalCostDefinition objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdditionalCostDefinitions $parameters
     * @return \StructType\GetAdditionalCostDefinitionsResponse|bool
     */
    public function GetAdditionalCostDefinitions(\StructType\GetAdditionalCostDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdditionalCostDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressTypes $parameters
     * @return \StructType\GetAddressTypesResponse|bool
     */
    public function GetAddressTypes(\StructType\GetAddressTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetArticles
     * Meta information extracted from the WSDL
     * - documentation: Gets single (filtered) Article objects or bulks of Articles based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArticles $parameters
     * @return \StructType\GetArticlesResponse|bool
     */
    public function GetArticles(\StructType\GetArticles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetArticles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBranches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBranches $parameters
     * @return \StructType\GetBranchesResponse|bool
     */
    public function GetBranches(\StructType\GetBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrands
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBrands $parameters
     * @return \StructType\GetBrandsResponse|bool
     */
    public function GetBrands(\StructType\GetBrands $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBrands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCharacteristics
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCharacteristics $parameters
     * @return \StructType\GetCharacteristicsResponse|bool
     */
    public function GetCharacteristics(\StructType\GetCharacteristics $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCharacteristics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCharacteristicTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCharacteristicTypes $parameters
     * @return \StructType\GetCharacteristicTypesResponse|bool
     */
    public function GetCharacteristicTypes(\StructType\GetCharacteristicTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCharacteristicTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountries $parameters
     * @return \StructType\GetCountriesResponse|bool
     */
    public function GetCountries(\StructType\GetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrencies $parameters
     * @return \StructType\GetCurrenciesResponse|bool
     */
    public function GetCurrencies(\StructType\GetCurrencies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomers
     * Meta information extracted from the WSDL
     * - documentation: Gets single (filtered) Customer objects or bulks of Customers based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomers $parameters
     * @return \StructType\GetCustomersResponse|bool
     */
    public function GetCustomers(\StructType\GetCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemCommChannelTypes
     * Meta information extracted from the WSDL
     * - documentation: Gets all available CommChannelTypes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSystemCommChannelTypes $parameters
     * @return \StructType\GetSystemCommChannelTypesResponse|bool
     */
    public function GetSystemCommChannelTypes(\StructType\GetSystemCommChannelTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemCommChannelTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerPurchaseHistory
     * Meta information extracted from the WSDL
     * - documentation: Gets filtered CustomerPurchasHistory objects based on customer specific sales/return history and specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerPurchaseHistory $parameters
     * @return \StructType\GetCustomerPurchaseHistoryResponse|bool
     */
    public function GetCustomerPurchaseHistory(\StructType\GetCustomerPurchaseHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerPurchaseHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmployees
     * Meta information extracted from the WSDL
     * - documentation: Gets single (filtered) employee object or bulks of employee based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmployees $parameters
     * @return \StructType\GetEmployeesResponse|bool
     */
    public function GetEmployees(\StructType\GetEmployees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEmployees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiscountReasons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiscountReasons $parameters
     * @return \StructType\GetDiscountReasonsResponse|bool
     */
    public function GetDiscountReasons(\StructType\GetDiscountReasons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDiscountReasons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryNotes $parameters
     * @return \StructType\GetDeliveryNotesResponse|bool
     */
    public function GetDeliveryNotes(\StructType\GetDeliveryNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices $parameters
     * @return \StructType\GetInvoicesResponse|bool
     */
    public function GetInvoices(\StructType\GetInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGoodsInAdvices
     * Meta information extracted from the WSDL
     * - documentation: Get supplier's delivery-notes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGoodsInAdvices $parameters
     * @return \StructType\GetGoodsInAdvicesResponse|bool
     */
    public function GetGoodsInAdvices(\StructType\GetGoodsInAdvices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGoodsInAdvices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManufacturerColours
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetManufacturerColours $parameters
     * @return \StructType\GetManufacturerColoursResponse|bool
     */
    public function GetManufacturerColours(\StructType\GetManufacturerColours $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManufacturerColours($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManufacturers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetManufacturers $parameters
     * @return \StructType\GetManufacturersResponse|bool
     */
    public function GetManufacturers(\StructType\GetManufacturers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManufacturers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrders $parameters
     * @return \StructType\GetOrdersResponse|bool
     */
    public function GetOrders(\StructType\GetOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenOrderStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpenOrderStock $parameters
     * @return \StructType\GetOpenOrderStockResponse|bool
     */
    public function GetOpenOrderStock(\StructType\GetOpenOrderStock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOpenOrderStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLanguages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguages $parameters
     * @return \StructType\GetLanguagesResponse|bool
     */
    public function GetLanguages(\StructType\GetLanguages $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLanguages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentTypes $parameters
     * @return \StructType\GetPaymentTypesResponse|bool
     */
    public function GetPaymentTypes(\StructType\GetPaymentTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductGroups $parameters
     * @return \StructType\GetProductGroupsResponse|bool
     */
    public function GetProductGroups(\StructType\GetProductGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalutations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSalutations $parameters
     * @return \StructType\GetSalutationsResponse|bool
     */
    public function GetSalutations(\StructType\GetSalutations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalutations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShops
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShops $parameters
     * @return \StructType\GetShopsResponse|bool
     */
    public function GetShops(\StructType\GetShops $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShops($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSizes $parameters
     * @return \StructType\GetSizesResponse|bool
     */
    public function GetSizes(\StructType\GetSizes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSizes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizeRanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSizeRanges $parameters
     * @return \StructType\GetSizeRangesResponse|bool
     */
    public function GetSizeRanges(\StructType\GetSizeRanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSizeRanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStocks
     * Meta information extracted from the WSDL
     * - documentation: Gets single (filtered) groups of StockInfo objects or bulks of StockInfo based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStocks $parameters
     * @return \StructType\GetStocksResponse|bool
     */
    public function GetStocks(\StructType\GetStocks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStocks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemColours
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSystemColours $parameters
     * @return \StructType\GetSystemColoursResponse|bool
     */
    public function GetSystemColours(\StructType\GetSystemColours $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemColours($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVats $parameters
     * @return \StructType\GetVatsResponse|bool
     */
    public function GetVats(\StructType\GetVats $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchers
     * Meta information extracted from the WSDL
     * - documentation: Gets filtered Voucher objects based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVouchers $parameters
     * @return \StructType\GetVouchersResponse|bool
     */
    public function GetVouchers(\StructType\GetVouchers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeletedObjectsIterated
     * Meta information extracted from the WSDL
     * - documentation: Gets filtered deleted objects based on specific iteration steps.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedObjectsIterated $parameters
     * @return \StructType\GetDeletedObjectsIteratedResponse|bool
     */
    public function GetDeletedObjectsIterated(\StructType\GetDeletedObjectsIterated $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeletedObjectsIterated($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Gets assembly, service and service reference status information about local web container and connected 4Retail WCF services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatus $parameters
     * @return \StructType\GetStatusResponse|bool
     */
    public function GetStatus(\StructType\GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIbts
     * Meta information extracted from the WSDL
     * - documentation: Gets a List of Ibts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIbts $parameters
     * @return \StructType\GetIbtsResponse|bool
     */
    public function GetIbts(\StructType\GetIbts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIbts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnReasons
     * Meta information extracted from the WSDL
     * - documentation: Gets all available ReturnReason objects (4Retail::PerTextbaustein).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReturnReasons $parameters
     * @return \StructType\GetReturnReasonsResponse|bool
     */
    public function GetReturnReasons(\StructType\GetReturnReasons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnReasons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAdditionalCostDefinitionsResponse|\StructType\GetAddressTypesResponse|\StructType\GetArticlesResponse|\StructType\GetBranchesResponse|\StructType\GetBrandsResponse|\StructType\GetCharacteristicsResponse|\StructType\GetCharacteristicTypesResponse|\StructType\GetCountriesResponse|\StructType\GetCurrenciesResponse|\StructType\GetCustomerPurchaseHistoryResponse|\StructType\GetCustomersResponse|\StructType\GetDeletedObjectsIteratedResponse|\StructType\GetDeliveryNotesResponse|\StructType\GetDiscountReasonsResponse|\StructType\GetEmployeesResponse|\StructType\GetGoodsInAdvicesResponse|\StructType\GetIbtsResponse|\StructType\GetInvoicesResponse|\StructType\GetLanguagesResponse|\StructType\GetManufacturerColoursResponse|\StructType\GetManufacturersResponse|\StructType\GetOpenOrderStockResponse|\StructType\GetOrdersResponse|\StructType\GetPaymentTypesResponse|\StructType\GetProductGroupsResponse|\StructType\GetReturnReasonsResponse|\StructType\GetSalutationsResponse|\StructType\GetShopsResponse|\StructType\GetSizeRangesResponse|\StructType\GetSizesResponse|\StructType\GetStatusResponse|\StructType\GetStocksResponse|\StructType\GetSystemColoursResponse|\StructType\GetSystemCommChannelTypesResponse|\StructType\GetVatsResponse|\StructType\GetVouchersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
