<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for OrderStatus EnumType
 * @subpackage Enumerations
 */
class OrderStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Entered'
     * @return string 'Entered'
     */
    const VALUE_ENTERED = 'Entered';
    /**
     * Constant for value 'Offered'
     * @return string 'Offered'
     */
    const VALUE_OFFERED = 'Offered';
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'ManuallyClosed'
     * @return string 'ManuallyClosed'
     */
    const VALUE_MANUALLY_CLOSED = 'ManuallyClosed';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ENTERED
     * @uses self::VALUE_OFFERED
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_MANUALLY_CLOSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ENTERED,
            self::VALUE_OFFERED,
            self::VALUE_ACCEPTED,
            self::VALUE_CANCELED,
            self::VALUE_CLOSED,
            self::VALUE_MANUALLY_CLOSED,
        );
    }
}
