<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTextInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfTextInfo extends AbstractStructArrayBase
{
    /**
     * The TextInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TextInfo[]
     */
    public $TextInfo;
    /**
     * Constructor method for ArrayOfTextInfo
     * @uses ArrayOfTextInfo::setTextInfo()
     * @param \StructType\TextInfo[] $textInfo
     */
    public function __construct(array $textInfo = array())
    {
        $this
            ->setTextInfo($textInfo);
    }
    /**
     * Get TextInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TextInfo[]|null
     */
    public function getTextInfo()
    {
        return isset($this->TextInfo) ? $this->TextInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTextInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextInfoForArrayConstraintsFromSetTextInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTextInfoTextInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTextInfoTextInfoItem instanceof \StructType\TextInfo) {
                $invalidValues[] = is_object($arrayOfTextInfoTextInfoItem) ? get_class($arrayOfTextInfoTextInfoItem) : sprintf('%s(%s)', gettype($arrayOfTextInfoTextInfoItem), var_export($arrayOfTextInfoTextInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TextInfo property can only contain items of type \StructType\TextInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TextInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TextInfo[] $textInfo
     * @return \ArrayType\ArrayOfTextInfo
     */
    public function setTextInfo(array $textInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($textInfoArrayErrorMessage = self::validateTextInfoForArrayConstraintsFromSetTextInfo($textInfo))) {
            throw new \InvalidArgumentException($textInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($textInfo) || (is_array($textInfo) && empty($textInfo))) {
            unset($this->TextInfo);
        } else {
            $this->TextInfo = $textInfo;
        }
        return $this;
    }
    /**
     * Add item to TextInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TextInfo $item
     * @return \ArrayType\ArrayOfTextInfo
     */
    public function addToTextInfo(\StructType\TextInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextInfo) {
            throw new \InvalidArgumentException(sprintf('The TextInfo property can only contain items of type \StructType\TextInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TextInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TextInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TextInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TextInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TextInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TextInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TextInfo
     */
    public function getAttributeName()
    {
        return 'TextInfo';
    }
}
