<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTaskMessage ArrayType
 * @subpackage Arrays
 */
class ArrayOfTaskMessage extends AbstractStructArrayBase
{
    /**
     * The TaskMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaskMessage[]
     */
    public $TaskMessage;
    /**
     * Constructor method for ArrayOfTaskMessage
     * @uses ArrayOfTaskMessage::setTaskMessage()
     * @param \StructType\TaskMessage[] $taskMessage
     */
    public function __construct(array $taskMessage = array())
    {
        $this
            ->setTaskMessage($taskMessage);
    }
    /**
     * Get TaskMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaskMessage[]|null
     */
    public function getTaskMessage()
    {
        return isset($this->TaskMessage) ? $this->TaskMessage : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskMessageForArrayConstraintsFromSetTaskMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTaskMessageTaskMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfTaskMessageTaskMessageItem instanceof \StructType\TaskMessage) {
                $invalidValues[] = is_object($arrayOfTaskMessageTaskMessageItem) ? get_class($arrayOfTaskMessageTaskMessageItem) : sprintf('%s(%s)', gettype($arrayOfTaskMessageTaskMessageItem), var_export($arrayOfTaskMessageTaskMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaskMessage property can only contain items of type \StructType\TaskMessage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaskMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TaskMessage[] $taskMessage
     * @return \ArrayType\ArrayOfTaskMessage
     */
    public function setTaskMessage(array $taskMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($taskMessageArrayErrorMessage = self::validateTaskMessageForArrayConstraintsFromSetTaskMessage($taskMessage))) {
            throw new \InvalidArgumentException($taskMessageArrayErrorMessage, __LINE__);
        }
        if (is_null($taskMessage) || (is_array($taskMessage) && empty($taskMessage))) {
            unset($this->TaskMessage);
        } else {
            $this->TaskMessage = $taskMessage;
        }
        return $this;
    }
    /**
     * Add item to TaskMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskMessage $item
     * @return \ArrayType\ArrayOfTaskMessage
     */
    public function addToTaskMessage(\StructType\TaskMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskMessage) {
            throw new \InvalidArgumentException(sprintf('The TaskMessage property can only contain items of type \StructType\TaskMessage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaskMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TaskMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TaskMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TaskMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TaskMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TaskMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaskMessage
     */
    public function getAttributeName()
    {
        return 'TaskMessage';
    }
}
