<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSize ArrayType
 * @subpackage Arrays
 */
class ArrayOfSize extends AbstractStructArrayBase
{
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Size[]
     */
    public $Size;
    /**
     * Constructor method for ArrayOfSize
     * @uses ArrayOfSize::setSize()
     * @param \StructType\Size[] $size
     */
    public function __construct(array $size = array())
    {
        $this
            ->setSize($size);
    }
    /**
     * Get Size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Size[]|null
     */
    public function getSize()
    {
        return isset($this->Size) ? $this->Size : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSize method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSize method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSizeForArrayConstraintsFromSetSize(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSizeSizeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSizeSizeItem instanceof \StructType\Size) {
                $invalidValues[] = is_object($arrayOfSizeSizeItem) ? get_class($arrayOfSizeSizeItem) : sprintf('%s(%s)', gettype($arrayOfSizeSizeItem), var_export($arrayOfSizeSizeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Size property can only contain items of type \StructType\Size, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Size[] $size
     * @return \ArrayType\ArrayOfSize
     */
    public function setSize(array $size = array())
    {
        // validation for constraint: array
        if ('' !== ($sizeArrayErrorMessage = self::validateSizeForArrayConstraintsFromSetSize($size))) {
            throw new \InvalidArgumentException($sizeArrayErrorMessage, __LINE__);
        }
        if (is_null($size) || (is_array($size) && empty($size))) {
            unset($this->Size);
        } else {
            $this->Size = $size;
        }
        return $this;
    }
    /**
     * Add item to Size value
     * @throws \InvalidArgumentException
     * @param \StructType\Size $item
     * @return \ArrayType\ArrayOfSize
     */
    public function addToSize(\StructType\Size $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Size) {
            throw new \InvalidArgumentException(sprintf('The Size property can only contain items of type \StructType\Size, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Size[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Size|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Size|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Size|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Size|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Size|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Size
     */
    public function getAttributeName()
    {
        return 'Size';
    }
}
