<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalutation ArrayType
 * @subpackage Arrays
 */
class ArrayOfSalutation extends AbstractStructArrayBase
{
    /**
     * The Salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Salutation[]
     */
    public $Salutation;
    /**
     * Constructor method for ArrayOfSalutation
     * @uses ArrayOfSalutation::setSalutation()
     * @param \StructType\Salutation[] $salutation
     */
    public function __construct(array $salutation = array())
    {
        $this
            ->setSalutation($salutation);
    }
    /**
     * Get Salutation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Salutation[]|null
     */
    public function getSalutation()
    {
        return isset($this->Salutation) ? $this->Salutation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalutation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalutation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalutationForArrayConstraintsFromSetSalutation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSalutationSalutationItem) {
            // validation for constraint: itemType
            if (!$arrayOfSalutationSalutationItem instanceof \StructType\Salutation) {
                $invalidValues[] = is_object($arrayOfSalutationSalutationItem) ? get_class($arrayOfSalutationSalutationItem) : sprintf('%s(%s)', gettype($arrayOfSalutationSalutationItem), var_export($arrayOfSalutationSalutationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Salutation property can only contain items of type \StructType\Salutation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Salutation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Salutation[] $salutation
     * @return \ArrayType\ArrayOfSalutation
     */
    public function setSalutation(array $salutation = array())
    {
        // validation for constraint: array
        if ('' !== ($salutationArrayErrorMessage = self::validateSalutationForArrayConstraintsFromSetSalutation($salutation))) {
            throw new \InvalidArgumentException($salutationArrayErrorMessage, __LINE__);
        }
        if (is_null($salutation) || (is_array($salutation) && empty($salutation))) {
            unset($this->Salutation);
        } else {
            $this->Salutation = $salutation;
        }
        return $this;
    }
    /**
     * Add item to Salutation value
     * @throws \InvalidArgumentException
     * @param \StructType\Salutation $item
     * @return \ArrayType\ArrayOfSalutation
     */
    public function addToSalutation(\StructType\Salutation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Salutation) {
            throw new \InvalidArgumentException(sprintf('The Salutation property can only contain items of type \StructType\Salutation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Salutation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Salutation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Salutation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Salutation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Salutation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Salutation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Salutation
     */
    public function getAttributeName()
    {
        return 'Salutation';
    }
}
