<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConfigurationEntry ArrayType
 * @subpackage Arrays
 */
class ArrayOfConfigurationEntry extends AbstractStructArrayBase
{
    /**
     * The ConfigurationEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ConfigurationEntry[]
     */
    public $ConfigurationEntry;
    /**
     * Constructor method for ArrayOfConfigurationEntry
     * @uses ArrayOfConfigurationEntry::setConfigurationEntry()
     * @param \StructType\ConfigurationEntry[] $configurationEntry
     */
    public function __construct(array $configurationEntry = array())
    {
        $this
            ->setConfigurationEntry($configurationEntry);
    }
    /**
     * Get ConfigurationEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConfigurationEntry[]|null
     */
    public function getConfigurationEntry()
    {
        return isset($this->ConfigurationEntry) ? $this->ConfigurationEntry : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConfigurationEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfigurationEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfigurationEntryForArrayConstraintsFromSetConfigurationEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfConfigurationEntryConfigurationEntryItem) {
            // validation for constraint: itemType
            if (!$arrayOfConfigurationEntryConfigurationEntryItem instanceof \StructType\ConfigurationEntry) {
                $invalidValues[] = is_object($arrayOfConfigurationEntryConfigurationEntryItem) ? get_class($arrayOfConfigurationEntryConfigurationEntryItem) : sprintf('%s(%s)', gettype($arrayOfConfigurationEntryConfigurationEntryItem), var_export($arrayOfConfigurationEntryConfigurationEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConfigurationEntry property can only contain items of type \StructType\ConfigurationEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConfigurationEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConfigurationEntry[] $configurationEntry
     * @return \ArrayType\ArrayOfConfigurationEntry
     */
    public function setConfigurationEntry(array $configurationEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($configurationEntryArrayErrorMessage = self::validateConfigurationEntryForArrayConstraintsFromSetConfigurationEntry($configurationEntry))) {
            throw new \InvalidArgumentException($configurationEntryArrayErrorMessage, __LINE__);
        }
        if (is_null($configurationEntry) || (is_array($configurationEntry) && empty($configurationEntry))) {
            unset($this->ConfigurationEntry);
        } else {
            $this->ConfigurationEntry = $configurationEntry;
        }
        return $this;
    }
    /**
     * Add item to ConfigurationEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfigurationEntry $item
     * @return \ArrayType\ArrayOfConfigurationEntry
     */
    public function addToConfigurationEntry(\StructType\ConfigurationEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConfigurationEntry) {
            throw new \InvalidArgumentException(sprintf('The ConfigurationEntry property can only contain items of type \StructType\ConfigurationEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConfigurationEntry[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ConfigurationEntry|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ConfigurationEntry|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ConfigurationEntry|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ConfigurationEntry|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ConfigurationEntry|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ConfigurationEntry
     */
    public function getAttributeName()
    {
        return 'ConfigurationEntry';
    }
}
