<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankAccount ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankAccount extends AbstractStructArrayBase
{
    /**
     * The BankAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BankAccount[]
     */
    public $BankAccount;
    /**
     * Constructor method for ArrayOfBankAccount
     * @uses ArrayOfBankAccount::setBankAccount()
     * @param \StructType\BankAccount[] $bankAccount
     */
    public function __construct(array $bankAccount = array())
    {
        $this
            ->setBankAccount($bankAccount);
    }
    /**
     * Get BankAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BankAccount[]|null
     */
    public function getBankAccount()
    {
        return isset($this->BankAccount) ? $this->BankAccount : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBankAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankAccountForArrayConstraintsFromSetBankAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBankAccountBankAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankAccountBankAccountItem instanceof \StructType\BankAccount) {
                $invalidValues[] = is_object($arrayOfBankAccountBankAccountItem) ? get_class($arrayOfBankAccountBankAccountItem) : sprintf('%s(%s)', gettype($arrayOfBankAccountBankAccountItem), var_export($arrayOfBankAccountBankAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BankAccount property can only contain items of type \StructType\BankAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BankAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount[] $bankAccount
     * @return \ArrayType\ArrayOfBankAccount
     */
    public function setBankAccount(array $bankAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($bankAccountArrayErrorMessage = self::validateBankAccountForArrayConstraintsFromSetBankAccount($bankAccount))) {
            throw new \InvalidArgumentException($bankAccountArrayErrorMessage, __LINE__);
        }
        if (is_null($bankAccount) || (is_array($bankAccount) && empty($bankAccount))) {
            unset($this->BankAccount);
        } else {
            $this->BankAccount = $bankAccount;
        }
        return $this;
    }
    /**
     * Add item to BankAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccount $item
     * @return \ArrayType\ArrayOfBankAccount
     */
    public function addToBankAccount(\StructType\BankAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankAccount) {
            throw new \InvalidArgumentException(sprintf('The BankAccount property can only contain items of type \StructType\BankAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BankAccount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BankAccount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BankAccount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BankAccount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BankAccount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BankAccount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BankAccount
     */
    public function getAttributeName()
    {
        return 'BankAccount';
    }
}
