<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoidableEntityContractBase StructType
 * @subpackage Structs
 */
abstract class VoidableEntityContractBase extends EntityContractBase
{
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ValidTo;
    /**
     * Constructor method for VoidableEntityContractBase
     * @uses VoidableEntityContractBase::setValidFrom()
     * @uses VoidableEntityContractBase::setValidTo()
     * @param string $validFrom
     * @param string $validTo
     */
    public function __construct($validFrom = null, $validTo = null)
    {
        $this
            ->setValidFrom($validFrom)
            ->setValidTo($validTo);
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\VoidableEntityContractBase
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ValidTo value
     * @return string
     */
    public function getValidTo()
    {
        return $this->ValidTo;
    }
    /**
     * Set ValidTo value
     * @param string $validTo
     * @return \StructType\VoidableEntityContractBase
     */
    public function setValidTo($validTo = null)
    {
        // validation for constraint: string
        if (!is_null($validTo) && !is_string($validTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validTo, true), gettype($validTo)), __LINE__);
        }
        $this->ValidTo = $validTo;
        return $this;
    }
}
