<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vat StructType
 * @subpackage Structs
 */
class Vat extends BaseContract_FullIDSet
{
    /**
     * The vatTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vatTypeId;
    /**
     * The VatConfigurationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VatConfigurationId;
    /**
     * The VatPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatPercent;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidFrom;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Vat
     * @uses Vat::setVatTypeId()
     * @uses Vat::setVatConfigurationId()
     * @uses Vat::setVatPercent()
     * @uses Vat::setValidFrom()
     * @uses Vat::setDescription()
     * @param int $vatTypeId
     * @param int $vatConfigurationId
     * @param float $vatPercent
     * @param string $validFrom
     * @param string $description
     */
    public function __construct($vatTypeId = null, $vatConfigurationId = null, $vatPercent = null, $validFrom = null, $description = null)
    {
        $this
            ->setVatTypeId($vatTypeId)
            ->setVatConfigurationId($vatConfigurationId)
            ->setVatPercent($vatPercent)
            ->setValidFrom($validFrom)
            ->setDescription($description);
    }
    /**
     * Get vatTypeId value
     * @return int
     */
    public function getVatTypeId()
    {
        return $this->vatTypeId;
    }
    /**
     * Set vatTypeId value
     * @param int $vatTypeId
     * @return \StructType\Vat
     */
    public function setVatTypeId($vatTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($vatTypeId) && !(is_int($vatTypeId) || ctype_digit($vatTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatTypeId, true), gettype($vatTypeId)), __LINE__);
        }
        $this->vatTypeId = $vatTypeId;
        return $this;
    }
    /**
     * Get VatConfigurationId value
     * @return int
     */
    public function getVatConfigurationId()
    {
        return $this->VatConfigurationId;
    }
    /**
     * Set VatConfigurationId value
     * @param int $vatConfigurationId
     * @return \StructType\Vat
     */
    public function setVatConfigurationId($vatConfigurationId = null)
    {
        // validation for constraint: int
        if (!is_null($vatConfigurationId) && !(is_int($vatConfigurationId) || ctype_digit($vatConfigurationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatConfigurationId, true), gettype($vatConfigurationId)), __LINE__);
        }
        $this->VatConfigurationId = $vatConfigurationId;
        return $this;
    }
    /**
     * Get VatPercent value
     * @return float
     */
    public function getVatPercent()
    {
        return $this->VatPercent;
    }
    /**
     * Set VatPercent value
     * @param float $vatPercent
     * @return \StructType\Vat
     */
    public function setVatPercent($vatPercent = null)
    {
        // validation for constraint: float
        if (!is_null($vatPercent) && !(is_float($vatPercent) || is_numeric($vatPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatPercent, true), gettype($vatPercent)), __LINE__);
        }
        $this->VatPercent = $vatPercent;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\Vat
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Vat
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
