<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskStatus StructType
 * @subpackage Structs
 */
class TaskStatus extends AbstractStructBase
{
    /**
     * The ProcessingStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProcessingStatus;
    /**
     * The TaskDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaskDuration;
    /**
     * The WorkerRecommendation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WorkerRecommendation;
    /**
     * The WorkerRecommendationDelaySeconds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WorkerRecommendationDelaySeconds;
    /**
     * The TaskInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaskInfo;
    /**
     * The TaskMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTaskMessage
     */
    public $TaskMessages;
    /**
     * Constructor method for TaskStatus
     * @uses TaskStatus::setProcessingStatus()
     * @uses TaskStatus::setTaskDuration()
     * @uses TaskStatus::setWorkerRecommendation()
     * @uses TaskStatus::setWorkerRecommendationDelaySeconds()
     * @uses TaskStatus::setTaskInfo()
     * @uses TaskStatus::setTaskMessages()
     * @param string $processingStatus
     * @param int $taskDuration
     * @param string $workerRecommendation
     * @param int $workerRecommendationDelaySeconds
     * @param string $taskInfo
     * @param \ArrayType\ArrayOfTaskMessage $taskMessages
     */
    public function __construct($processingStatus = null, $taskDuration = null, $workerRecommendation = null, $workerRecommendationDelaySeconds = null, $taskInfo = null, \ArrayType\ArrayOfTaskMessage $taskMessages = null)
    {
        $this
            ->setProcessingStatus($processingStatus)
            ->setTaskDuration($taskDuration)
            ->setWorkerRecommendation($workerRecommendation)
            ->setWorkerRecommendationDelaySeconds($workerRecommendationDelaySeconds)
            ->setTaskInfo($taskInfo)
            ->setTaskMessages($taskMessages);
    }
    /**
     * Get ProcessingStatus value
     * @return string
     */
    public function getProcessingStatus()
    {
        return $this->ProcessingStatus;
    }
    /**
     * Set ProcessingStatus value
     * @uses \EnumType\ProcessingStatus::valueIsValid()
     * @uses \EnumType\ProcessingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processingStatus
     * @return \StructType\TaskStatus
     */
    public function setProcessingStatus($processingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessingStatus::valueIsValid($processingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProcessingStatus', is_array($processingStatus) ? implode(', ', $processingStatus) : var_export($processingStatus, true), implode(', ', \EnumType\ProcessingStatus::getValidValues())), __LINE__);
        }
        $this->ProcessingStatus = $processingStatus;
        return $this;
    }
    /**
     * Get TaskDuration value
     * @return int
     */
    public function getTaskDuration()
    {
        return $this->TaskDuration;
    }
    /**
     * Set TaskDuration value
     * @param int $taskDuration
     * @return \StructType\TaskStatus
     */
    public function setTaskDuration($taskDuration = null)
    {
        // validation for constraint: int
        if (!is_null($taskDuration) && !(is_int($taskDuration) || ctype_digit($taskDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taskDuration, true), gettype($taskDuration)), __LINE__);
        }
        $this->TaskDuration = $taskDuration;
        return $this;
    }
    /**
     * Get WorkerRecommendation value
     * @return string
     */
    public function getWorkerRecommendation()
    {
        return $this->WorkerRecommendation;
    }
    /**
     * Set WorkerRecommendation value
     * @uses \EnumType\WorkerRecommendation::valueIsValid()
     * @uses \EnumType\WorkerRecommendation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workerRecommendation
     * @return \StructType\TaskStatus
     */
    public function setWorkerRecommendation($workerRecommendation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkerRecommendation::valueIsValid($workerRecommendation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WorkerRecommendation', is_array($workerRecommendation) ? implode(', ', $workerRecommendation) : var_export($workerRecommendation, true), implode(', ', \EnumType\WorkerRecommendation::getValidValues())), __LINE__);
        }
        $this->WorkerRecommendation = $workerRecommendation;
        return $this;
    }
    /**
     * Get WorkerRecommendationDelaySeconds value
     * @return int
     */
    public function getWorkerRecommendationDelaySeconds()
    {
        return $this->WorkerRecommendationDelaySeconds;
    }
    /**
     * Set WorkerRecommendationDelaySeconds value
     * @param int $workerRecommendationDelaySeconds
     * @return \StructType\TaskStatus
     */
    public function setWorkerRecommendationDelaySeconds($workerRecommendationDelaySeconds = null)
    {
        // validation for constraint: int
        if (!is_null($workerRecommendationDelaySeconds) && !(is_int($workerRecommendationDelaySeconds) || ctype_digit($workerRecommendationDelaySeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workerRecommendationDelaySeconds, true), gettype($workerRecommendationDelaySeconds)), __LINE__);
        }
        $this->WorkerRecommendationDelaySeconds = $workerRecommendationDelaySeconds;
        return $this;
    }
    /**
     * Get TaskInfo value
     * @return string|null
     */
    public function getTaskInfo()
    {
        return $this->TaskInfo;
    }
    /**
     * Set TaskInfo value
     * @param string $taskInfo
     * @return \StructType\TaskStatus
     */
    public function setTaskInfo($taskInfo = null)
    {
        // validation for constraint: string
        if (!is_null($taskInfo) && !is_string($taskInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskInfo, true), gettype($taskInfo)), __LINE__);
        }
        $this->TaskInfo = $taskInfo;
        return $this;
    }
    /**
     * Get TaskMessages value
     * @return \ArrayType\ArrayOfTaskMessage|null
     */
    public function getTaskMessages()
    {
        return $this->TaskMessages;
    }
    /**
     * Set TaskMessages value
     * @param \ArrayType\ArrayOfTaskMessage $taskMessages
     * @return \StructType\TaskStatus
     */
    public function setTaskMessages(\ArrayType\ArrayOfTaskMessage $taskMessages = null)
    {
        $this->TaskMessages = $taskMessages;
        return $this;
    }
}
