<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SizeRange StructType
 * @subpackage Structs
 */
class SizeRange extends BaseContract_FullIDSet
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Sizes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSize
     */
    public $Sizes;
    /**
     * Constructor method for SizeRange
     * @uses SizeRange::setDescription()
     * @uses SizeRange::setSizes()
     * @param string $description
     * @param \ArrayType\ArrayOfSize $sizes
     */
    public function __construct($description = null, \ArrayType\ArrayOfSize $sizes = null)
    {
        $this
            ->setDescription($description)
            ->setSizes($sizes);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SizeRange
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Sizes value
     * @return \ArrayType\ArrayOfSize|null
     */
    public function getSizes()
    {
        return $this->Sizes;
    }
    /**
     * Set Sizes value
     * @param \ArrayType\ArrayOfSize $sizes
     * @return \StructType\SizeRange
     */
    public function setSizes(\ArrayType\ArrayOfSize $sizes = null)
    {
        $this->Sizes = $sizes;
        return $this;
    }
}
