<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceStatus StructType
 * @subpackage Structs
 */
class ServiceStatus extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The SystemDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SystemDate;
    /**
     * The MemoryUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MemoryUsage;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceID;
    /**
     * The ServiceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceVersion;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ComponentConfiguration
     */
    public $Configuration;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceReference
     */
    public $References;
    /**
     * The ProcessName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcessName;
    /**
     * Constructor method for ServiceStatus
     * @uses ServiceStatus::setStatus()
     * @uses ServiceStatus::setSystemDate()
     * @uses ServiceStatus::setMemoryUsage()
     * @uses ServiceStatus::setServiceID()
     * @uses ServiceStatus::setServiceVersion()
     * @uses ServiceStatus::setConfiguration()
     * @uses ServiceStatus::setReferences()
     * @uses ServiceStatus::setProcessName()
     * @param string $status
     * @param string $systemDate
     * @param int $memoryUsage
     * @param string $serviceID
     * @param string $serviceVersion
     * @param \StructType\ComponentConfiguration $configuration
     * @param \ArrayType\ArrayOfServiceReference $references
     * @param string $processName
     */
    public function __construct($status = null, $systemDate = null, $memoryUsage = null, $serviceID = null, $serviceVersion = null, \StructType\ComponentConfiguration $configuration = null, \ArrayType\ArrayOfServiceReference $references = null, $processName = null)
    {
        $this
            ->setStatus($status)
            ->setSystemDate($systemDate)
            ->setMemoryUsage($memoryUsage)
            ->setServiceID($serviceID)
            ->setServiceVersion($serviceVersion)
            ->setConfiguration($configuration)
            ->setReferences($references)
            ->setProcessName($processName);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ComponentStatus::valueIsValid()
     * @uses \EnumType\ComponentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ServiceStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComponentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ComponentStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ComponentStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SystemDate value
     * @return string
     */
    public function getSystemDate()
    {
        return $this->SystemDate;
    }
    /**
     * Set SystemDate value
     * @param string $systemDate
     * @return \StructType\ServiceStatus
     */
    public function setSystemDate($systemDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemDate) && !is_string($systemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemDate, true), gettype($systemDate)), __LINE__);
        }
        $this->SystemDate = $systemDate;
        return $this;
    }
    /**
     * Get MemoryUsage value
     * @return int
     */
    public function getMemoryUsage()
    {
        return $this->MemoryUsage;
    }
    /**
     * Set MemoryUsage value
     * @param int $memoryUsage
     * @return \StructType\ServiceStatus
     */
    public function setMemoryUsage($memoryUsage = null)
    {
        // validation for constraint: int
        if (!is_null($memoryUsage) && !(is_int($memoryUsage) || ctype_digit($memoryUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memoryUsage, true), gettype($memoryUsage)), __LINE__);
        }
        $this->MemoryUsage = $memoryUsage;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\ServiceStatus
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get ServiceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->ServiceVersion;
    }
    /**
     * Set ServiceVersion value
     * @param string $serviceVersion
     * @return \StructType\ServiceStatus
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVersion, true), gettype($serviceVersion)), __LINE__);
        }
        $this->ServiceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get Configuration value
     * @return \StructType\ComponentConfiguration|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param \StructType\ComponentConfiguration $configuration
     * @return \StructType\ServiceStatus
     */
    public function setConfiguration(\StructType\ComponentConfiguration $configuration = null)
    {
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get References value
     * @return \ArrayType\ArrayOfServiceReference|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \ArrayType\ArrayOfServiceReference $references
     * @return \StructType\ServiceStatus
     */
    public function setReferences(\ArrayType\ArrayOfServiceReference $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get ProcessName value
     * @return string|null
     */
    public function getProcessName()
    {
        return $this->ProcessName;
    }
    /**
     * Set ProcessName value
     * @param string $processName
     * @return \StructType\ServiceStatus
     */
    public function setProcessName($processName = null)
    {
        // validation for constraint: string
        if (!is_null($processName) && !is_string($processName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processName, true), gettype($processName)), __LINE__);
        }
        $this->ProcessName = $processName;
        return $this;
    }
}
