<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendStockCorrectionDetailRequest StructType
 * @subpackage Structs
 */
class SendStockCorrectionDetailRequest extends AbstractStructBase
{
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The IsAbsQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAbsQty;
    /**
     * The ScanCodeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanCodeId;
    /**
     * The ReasonText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonText;
    /**
     * Constructor method for SendStockCorrectionDetailRequest
     * @uses SendStockCorrectionDetailRequest::setQty()
     * @uses SendStockCorrectionDetailRequest::setIsAbsQty()
     * @uses SendStockCorrectionDetailRequest::setScanCodeId()
     * @uses SendStockCorrectionDetailRequest::setReasonText()
     * @param float $qty
     * @param bool $isAbsQty
     * @param string $scanCodeId
     * @param string $reasonText
     */
    public function __construct($qty = null, $isAbsQty = null, $scanCodeId = null, $reasonText = null)
    {
        $this
            ->setQty($qty)
            ->setIsAbsQty($isAbsQty)
            ->setScanCodeId($scanCodeId)
            ->setReasonText($reasonText);
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\SendStockCorrectionDetailRequest
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get IsAbsQty value
     * @return bool
     */
    public function getIsAbsQty()
    {
        return $this->IsAbsQty;
    }
    /**
     * Set IsAbsQty value
     * @param bool $isAbsQty
     * @return \StructType\SendStockCorrectionDetailRequest
     */
    public function setIsAbsQty($isAbsQty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAbsQty) && !is_bool($isAbsQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAbsQty, true), gettype($isAbsQty)), __LINE__);
        }
        $this->IsAbsQty = $isAbsQty;
        return $this;
    }
    /**
     * Get ScanCodeId value
     * @return string|null
     */
    public function getScanCodeId()
    {
        return $this->ScanCodeId;
    }
    /**
     * Set ScanCodeId value
     * @param string $scanCodeId
     * @return \StructType\SendStockCorrectionDetailRequest
     */
    public function setScanCodeId($scanCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($scanCodeId) && !is_string($scanCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanCodeId, true), gettype($scanCodeId)), __LINE__);
        }
        $this->ScanCodeId = $scanCodeId;
        return $this;
    }
    /**
     * Get ReasonText value
     * @return string|null
     */
    public function getReasonText()
    {
        return $this->ReasonText;
    }
    /**
     * Set ReasonText value
     * @param string $reasonText
     * @return \StructType\SendStockCorrectionDetailRequest
     */
    public function setReasonText($reasonText = null)
    {
        // validation for constraint: string
        if (!is_null($reasonText) && !is_string($reasonText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonText, true), gettype($reasonText)), __LINE__);
        }
        $this->ReasonText = $reasonText;
        return $this;
    }
}
