<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendOrderPosition StructType
 * @subpackage Structs
 */
class SendOrderPosition extends EntityContractBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The IsPercentDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPercentDiscount;
    /**
     * The Ean
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ean;
    /**
     * Constructor method for SendOrderPosition
     * @uses SendOrderPosition::setQuantity()
     * @uses SendOrderPosition::setPrice()
     * @uses SendOrderPosition::setDiscount()
     * @uses SendOrderPosition::setIsPercentDiscount()
     * @uses SendOrderPosition::setEan()
     * @param float $quantity
     * @param float $price
     * @param float $discount
     * @param bool $isPercentDiscount
     * @param string $ean
     */
    public function __construct($quantity = null, $price = null, $discount = null, $isPercentDiscount = null, $ean = null)
    {
        $this
            ->setQuantity($quantity)
            ->setPrice($price)
            ->setDiscount($discount)
            ->setIsPercentDiscount($isPercentDiscount)
            ->setEan($ean);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\SendOrderPosition
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\SendOrderPosition
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\SendOrderPosition
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get IsPercentDiscount value
     * @return bool
     */
    public function getIsPercentDiscount()
    {
        return $this->IsPercentDiscount;
    }
    /**
     * Set IsPercentDiscount value
     * @param bool $isPercentDiscount
     * @return \StructType\SendOrderPosition
     */
    public function setIsPercentDiscount($isPercentDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPercentDiscount) && !is_bool($isPercentDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPercentDiscount, true), gettype($isPercentDiscount)), __LINE__);
        }
        $this->IsPercentDiscount = $isPercentDiscount;
        return $this;
    }
    /**
     * Get Ean value
     * @return string|null
     */
    public function getEan()
    {
        return $this->Ean;
    }
    /**
     * Set Ean value
     * @param string $ean
     * @return \StructType\SendOrderPosition
     */
    public function setEan($ean = null)
    {
        // validation for constraint: string
        if (!is_null($ean) && !is_string($ean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ean, true), gettype($ean)), __LINE__);
        }
        $this->Ean = $ean;
        return $this;
    }
}
