<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceRequest StructType
 * @subpackage Structs
 */
class SendInvoiceRequest extends AbstractStructBase
{
    /**
     * The InvoiceTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceTimestamp;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The InvoicePositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoicePosition
     */
    public $InvoicePositions;
    /**
     * Constructor method for SendInvoiceRequest
     * @uses SendInvoiceRequest::setInvoiceTimestamp()
     * @uses SendInvoiceRequest::setInvoiceId()
     * @uses SendInvoiceRequest::setDeliveryNoteId()
     * @uses SendInvoiceRequest::setOrderId()
     * @uses SendInvoiceRequest::setShopId()
     * @uses SendInvoiceRequest::setShopCustomerId()
     * @uses SendInvoiceRequest::setCustomerId()
     * @uses SendInvoiceRequest::setInvoicePositions()
     * @param string $invoiceTimestamp
     * @param string $invoiceId
     * @param string $deliveryNoteId
     * @param string $orderId
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     * @param \ArrayType\ArrayOfInvoicePosition $invoicePositions
     */
    public function __construct($invoiceTimestamp = null, $invoiceId = null, $deliveryNoteId = null, $orderId = null, $shopId = null, $shopCustomerId = null, $customerId = null, \ArrayType\ArrayOfInvoicePosition $invoicePositions = null)
    {
        $this
            ->setInvoiceTimestamp($invoiceTimestamp)
            ->setInvoiceId($invoiceId)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setOrderId($orderId)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId)
            ->setInvoicePositions($invoicePositions);
    }
    /**
     * Get InvoiceTimestamp value
     * @return string
     */
    public function getInvoiceTimestamp()
    {
        return $this->InvoiceTimestamp;
    }
    /**
     * Set InvoiceTimestamp value
     * @param string $invoiceTimestamp
     * @return \StructType\SendInvoiceRequest
     */
    public function setInvoiceTimestamp($invoiceTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTimestamp) && !is_string($invoiceTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTimestamp, true), gettype($invoiceTimestamp)), __LINE__);
        }
        $this->InvoiceTimestamp = $invoiceTimestamp;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \StructType\SendInvoiceRequest
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\SendInvoiceRequest
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\SendInvoiceRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\SendInvoiceRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\SendInvoiceRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendInvoiceRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InvoicePositions value
     * @return \ArrayType\ArrayOfInvoicePosition|null
     */
    public function getInvoicePositions()
    {
        return $this->InvoicePositions;
    }
    /**
     * Set InvoicePositions value
     * @param \ArrayType\ArrayOfInvoicePosition $invoicePositions
     * @return \StructType\SendInvoiceRequest
     */
    public function setInvoicePositions(\ArrayType\ArrayOfInvoicePosition $invoicePositions = null)
    {
        $this->InvoicePositions = $invoicePositions;
        return $this;
    }
}
