<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDeliveryNoteRequest StructType
 * @subpackage Structs
 */
class SendDeliveryNoteRequest extends AbstractStructBase
{
    /**
     * The DeliveryNoteTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryNoteTimestamp;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The DeliveryNotePositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeliveryNotePosition
     */
    public $DeliveryNotePositions;
    /**
     * Constructor method for SendDeliveryNoteRequest
     * @uses SendDeliveryNoteRequest::setDeliveryNoteTimestamp()
     * @uses SendDeliveryNoteRequest::setDeliveryNoteId()
     * @uses SendDeliveryNoteRequest::setOrderId()
     * @uses SendDeliveryNoteRequest::setShopId()
     * @uses SendDeliveryNoteRequest::setShopCustomerId()
     * @uses SendDeliveryNoteRequest::setCustomerId()
     * @uses SendDeliveryNoteRequest::setDeliveryNotePositions()
     * @param string $deliveryNoteTimestamp
     * @param string $deliveryNoteId
     * @param string $orderId
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     * @param \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions
     */
    public function __construct($deliveryNoteTimestamp = null, $deliveryNoteId = null, $orderId = null, $shopId = null, $shopCustomerId = null, $customerId = null, \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions = null)
    {
        $this
            ->setDeliveryNoteTimestamp($deliveryNoteTimestamp)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setOrderId($orderId)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId)
            ->setDeliveryNotePositions($deliveryNotePositions);
    }
    /**
     * Get DeliveryNoteTimestamp value
     * @return string
     */
    public function getDeliveryNoteTimestamp()
    {
        return $this->DeliveryNoteTimestamp;
    }
    /**
     * Set DeliveryNoteTimestamp value
     * @param string $deliveryNoteTimestamp
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setDeliveryNoteTimestamp($deliveryNoteTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteTimestamp) && !is_string($deliveryNoteTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteTimestamp, true), gettype($deliveryNoteTimestamp)), __LINE__);
        }
        $this->DeliveryNoteTimestamp = $deliveryNoteTimestamp;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeliveryNotePositions value
     * @return \ArrayType\ArrayOfDeliveryNotePosition|null
     */
    public function getDeliveryNotePositions()
    {
        return $this->DeliveryNotePositions;
    }
    /**
     * Set DeliveryNotePositions value
     * @param \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions
     * @return \StructType\SendDeliveryNoteRequest
     */
    public function setDeliveryNotePositions(\ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions = null)
    {
        $this->DeliveryNotePositions = $deliveryNotePositions;
        return $this;
    }
}
