<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Salutation StructType
 * @subpackage Structs
 */
class Salutation extends BaseContract_Oid
{
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Target;
    /**
     * The BusinessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessKey;
    /**
     * The SalutationText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalutationText;
    /**
     * The ShortSalutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortSalutation;
    /**
     * Constructor method for Salutation
     * @uses Salutation::setTarget()
     * @uses Salutation::setBusinessKey()
     * @uses Salutation::setSalutationText()
     * @uses Salutation::setShortSalutation()
     * @param string $target
     * @param string $businessKey
     * @param string $salutationText
     * @param string $shortSalutation
     */
    public function __construct($target = null, $businessKey = null, $salutationText = null, $shortSalutation = null)
    {
        $this
            ->setTarget($target)
            ->setBusinessKey($businessKey)
            ->setSalutationText($salutationText)
            ->setShortSalutation($shortSalutation);
    }
    /**
     * Get Target value
     * @return string
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \EnumType\SalutationTarget::valueIsValid()
     * @uses \EnumType\SalutationTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \StructType\Salutation
     */
    public function setTarget($target = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalutationTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalutationTarget', is_array($target) ? implode(', ', $target) : var_export($target, true), implode(', ', \EnumType\SalutationTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get BusinessKey value
     * @return string|null
     */
    public function getBusinessKey()
    {
        return $this->BusinessKey;
    }
    /**
     * Set BusinessKey value
     * @param string $businessKey
     * @return \StructType\Salutation
     */
    public function setBusinessKey($businessKey = null)
    {
        // validation for constraint: string
        if (!is_null($businessKey) && !is_string($businessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessKey, true), gettype($businessKey)), __LINE__);
        }
        $this->BusinessKey = $businessKey;
        return $this;
    }
    /**
     * Get SalutationText value
     * @return string|null
     */
    public function getSalutationText()
    {
        return $this->SalutationText;
    }
    /**
     * Set SalutationText value
     * @param string $salutationText
     * @return \StructType\Salutation
     */
    public function setSalutationText($salutationText = null)
    {
        // validation for constraint: string
        if (!is_null($salutationText) && !is_string($salutationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutationText, true), gettype($salutationText)), __LINE__);
        }
        $this->SalutationText = $salutationText;
        return $this;
    }
    /**
     * Get ShortSalutation value
     * @return string|null
     */
    public function getShortSalutation()
    {
        return $this->ShortSalutation;
    }
    /**
     * Set ShortSalutation value
     * @param string $shortSalutation
     * @return \StructType\Salutation
     */
    public function setShortSalutation($shortSalutation = null)
    {
        // validation for constraint: string
        if (!is_null($shortSalutation) && !is_string($shortSalutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortSalutation, true), gettype($shortSalutation)), __LINE__);
        }
        $this->ShortSalutation = $shortSalutation;
        return $this;
    }
}
