<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStockRequest StructType
 * @subpackage Structs
 */
class OrderStockRequest extends BaseIterationRequest
{
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleId;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * Constructor method for OrderStockRequest
     * @uses OrderStockRequest::setChangedSinceDate()
     * @uses OrderStockRequest::setOrderId()
     * @uses OrderStockRequest::setArticleId()
     * @uses OrderStockRequest::setEAN()
     * @uses OrderStockRequest::setBranchId()
     * @param string $changedSinceDate
     * @param string $orderId
     * @param string $articleId
     * @param string $eAN
     * @param string $branchId
     */
    public function __construct($changedSinceDate = null, $orderId = null, $articleId = null, $eAN = null, $branchId = null)
    {
        $this
            ->setChangedSinceDate($changedSinceDate)
            ->setOrderId($orderId)
            ->setArticleId($articleId)
            ->setEAN($eAN)
            ->setBranchId($branchId);
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\OrderStockRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\OrderStockRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ArticleId value
     * @return string|null
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param string $articleId
     * @return \StructType\OrderStockRequest
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: string
        if (!is_null($articleId) && !is_string($articleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\OrderStockRequest
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\OrderStockRequest
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
}
