<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderPosition StructType
 * @subpackage Structs
 */
class OrderPosition extends BaseContract_Oid
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The IsPercentDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPercentDiscount;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleId;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * Constructor method for OrderPosition
     * @uses OrderPosition::setQuantity()
     * @uses OrderPosition::setPrice()
     * @uses OrderPosition::setDiscount()
     * @uses OrderPosition::setIsPercentDiscount()
     * @uses OrderPosition::setEAN()
     * @uses OrderPosition::setArticleId()
     * @uses OrderPosition::setSize()
     * @uses OrderPosition::setColor()
     * @param float $quantity
     * @param float $price
     * @param float $discount
     * @param bool $isPercentDiscount
     * @param string $eAN
     * @param string $articleId
     * @param string $size
     * @param string $color
     */
    public function __construct($quantity = null, $price = null, $discount = null, $isPercentDiscount = null, $eAN = null, $articleId = null, $size = null, $color = null)
    {
        $this
            ->setQuantity($quantity)
            ->setPrice($price)
            ->setDiscount($discount)
            ->setIsPercentDiscount($isPercentDiscount)
            ->setEAN($eAN)
            ->setArticleId($articleId)
            ->setSize($size)
            ->setColor($color);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\OrderPosition
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\OrderPosition
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\OrderPosition
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get IsPercentDiscount value
     * @return bool
     */
    public function getIsPercentDiscount()
    {
        return $this->IsPercentDiscount;
    }
    /**
     * Set IsPercentDiscount value
     * @param bool $isPercentDiscount
     * @return \StructType\OrderPosition
     */
    public function setIsPercentDiscount($isPercentDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPercentDiscount) && !is_bool($isPercentDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPercentDiscount, true), gettype($isPercentDiscount)), __LINE__);
        }
        $this->IsPercentDiscount = $isPercentDiscount;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\OrderPosition
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get ArticleId value
     * @return string|null
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param string $articleId
     * @return \StructType\OrderPosition
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: string
        if (!is_null($articleId) && !is_string($articleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\OrderPosition
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\OrderPosition
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
}
