<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manufacturer StructType
 * @subpackage Structs
 */
class Manufacturer extends BaseContract_FullIDSet
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxID;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Contact;
    /**
     * Constructor method for Manufacturer
     * @uses Manufacturer::setDescription()
     * @uses Manufacturer::setTaxID()
     * @uses Manufacturer::setContact()
     * @param string $description
     * @param string $taxID
     * @param \StructType\Person $contact
     */
    public function __construct($description = null, $taxID = null, \StructType\Person $contact = null)
    {
        $this
            ->setDescription($description)
            ->setTaxID($taxID)
            ->setContact($contact);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Manufacturer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\Manufacturer
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\Person|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\Person $contact
     * @return \StructType\Manufacturer
     */
    public function setContact(\StructType\Person $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
}
