<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IterationStatus StructType
 * @subpackage Structs
 */
class IterationStatus extends AbstractStructBase
{
    /**
     * The MaxCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxCount;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The RequestedBlockIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestedBlockIndex;
    /**
     * The RequestedBlockSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestedBlockSize;
    /**
     * The IterationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IterationId;
    /**
     * The IterationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IterationInfo;
    /**
     * Constructor method for IterationStatus
     * @uses IterationStatus::setMaxCount()
     * @uses IterationStatus::setCount()
     * @uses IterationStatus::setRequestedBlockIndex()
     * @uses IterationStatus::setRequestedBlockSize()
     * @uses IterationStatus::setIterationId()
     * @uses IterationStatus::setIterationInfo()
     * @param int $maxCount
     * @param int $count
     * @param int $requestedBlockIndex
     * @param int $requestedBlockSize
     * @param string $iterationId
     * @param string $iterationInfo
     */
    public function __construct($maxCount = null, $count = null, $requestedBlockIndex = null, $requestedBlockSize = null, $iterationId = null, $iterationInfo = null)
    {
        $this
            ->setMaxCount($maxCount)
            ->setCount($count)
            ->setRequestedBlockIndex($requestedBlockIndex)
            ->setRequestedBlockSize($requestedBlockSize)
            ->setIterationId($iterationId)
            ->setIterationInfo($iterationInfo);
    }
    /**
     * Get MaxCount value
     * @return int
     */
    public function getMaxCount()
    {
        return $this->MaxCount;
    }
    /**
     * Set MaxCount value
     * @param int $maxCount
     * @return \StructType\IterationStatus
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxCount) && !(is_int($maxCount) || ctype_digit($maxCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCount, true), gettype($maxCount)), __LINE__);
        }
        $this->MaxCount = $maxCount;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\IterationStatus
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get RequestedBlockIndex value
     * @return int
     */
    public function getRequestedBlockIndex()
    {
        return $this->RequestedBlockIndex;
    }
    /**
     * Set RequestedBlockIndex value
     * @param int $requestedBlockIndex
     * @return \StructType\IterationStatus
     */
    public function setRequestedBlockIndex($requestedBlockIndex = null)
    {
        // validation for constraint: int
        if (!is_null($requestedBlockIndex) && !(is_int($requestedBlockIndex) || ctype_digit($requestedBlockIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedBlockIndex, true), gettype($requestedBlockIndex)), __LINE__);
        }
        $this->RequestedBlockIndex = $requestedBlockIndex;
        return $this;
    }
    /**
     * Get RequestedBlockSize value
     * @return int
     */
    public function getRequestedBlockSize()
    {
        return $this->RequestedBlockSize;
    }
    /**
     * Set RequestedBlockSize value
     * @param int $requestedBlockSize
     * @return \StructType\IterationStatus
     */
    public function setRequestedBlockSize($requestedBlockSize = null)
    {
        // validation for constraint: int
        if (!is_null($requestedBlockSize) && !(is_int($requestedBlockSize) || ctype_digit($requestedBlockSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedBlockSize, true), gettype($requestedBlockSize)), __LINE__);
        }
        $this->RequestedBlockSize = $requestedBlockSize;
        return $this;
    }
    /**
     * Get IterationId value
     * @return string|null
     */
    public function getIterationId()
    {
        return $this->IterationId;
    }
    /**
     * Set IterationId value
     * @param string $iterationId
     * @return \StructType\IterationStatus
     */
    public function setIterationId($iterationId = null)
    {
        // validation for constraint: string
        if (!is_null($iterationId) && !is_string($iterationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iterationId, true), gettype($iterationId)), __LINE__);
        }
        $this->IterationId = $iterationId;
        return $this;
    }
    /**
     * Get IterationInfo value
     * @return string|null
     */
    public function getIterationInfo()
    {
        return $this->IterationInfo;
    }
    /**
     * Set IterationInfo value
     * @param string $iterationInfo
     * @return \StructType\IterationStatus
     */
    public function setIterationInfo($iterationInfo = null)
    {
        // validation for constraint: string
        if (!is_null($iterationInfo) && !is_string($iterationInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iterationInfo, true), gettype($iterationInfo)), __LINE__);
        }
        $this->IterationInfo = $iterationInfo;
        return $this;
    }
}
