<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IbtDetailRequest StructType
 * @subpackage Structs
 */
class IbtDetailRequest extends AbstractStructBase
{
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The Ean
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ean;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The FLTPAToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FLTPAToken;
    /**
     * Constructor method for IbtDetailRequest
     * @uses IbtDetailRequest::setQty()
     * @uses IbtDetailRequest::setEan()
     * @uses IbtDetailRequest::setMemo()
     * @uses IbtDetailRequest::setFLTPAToken()
     * @param float $qty
     * @param string $ean
     * @param string $memo
     * @param string $fLTPAToken
     */
    public function __construct($qty = null, $ean = null, $memo = null, $fLTPAToken = null)
    {
        $this
            ->setQty($qty)
            ->setEan($ean)
            ->setMemo($memo)
            ->setFLTPAToken($fLTPAToken);
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\IbtDetailRequest
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get Ean value
     * @return string|null
     */
    public function getEan()
    {
        return $this->Ean;
    }
    /**
     * Set Ean value
     * @param string $ean
     * @return \StructType\IbtDetailRequest
     */
    public function setEan($ean = null)
    {
        // validation for constraint: string
        if (!is_null($ean) && !is_string($ean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ean, true), gettype($ean)), __LINE__);
        }
        $this->Ean = $ean;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\IbtDetailRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get FLTPAToken value
     * @return string|null
     */
    public function getFLTPAToken()
    {
        return $this->FLTPAToken;
    }
    /**
     * Set FLTPAToken value
     * @param string $fLTPAToken
     * @return \StructType\IbtDetailRequest
     */
    public function setFLTPAToken($fLTPAToken = null)
    {
        // validation for constraint: string
        if (!is_null($fLTPAToken) && !is_string($fLTPAToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fLTPAToken, true), gettype($fLTPAToken)), __LINE__);
        }
        $this->FLTPAToken = $fLTPAToken;
        return $this;
    }
}
