<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsInAdviceDetailRequest StructType
 * @subpackage Structs
 */
class GoodsInAdviceDetailRequest extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The CheckedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CheckedQuantity;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * Constructor method for GoodsInAdviceDetailRequest
     * @uses GoodsInAdviceDetailRequest::setPosition()
     * @uses GoodsInAdviceDetailRequest::setCheckedQuantity()
     * @uses GoodsInAdviceDetailRequest::setEAN()
     * @param int $position
     * @param float $checkedQuantity
     * @param string $eAN
     */
    public function __construct($position = null, $checkedQuantity = null, $eAN = null)
    {
        $this
            ->setPosition($position)
            ->setCheckedQuantity($checkedQuantity)
            ->setEAN($eAN);
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\GoodsInAdviceDetailRequest
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CheckedQuantity value
     * @return float
     */
    public function getCheckedQuantity()
    {
        return $this->CheckedQuantity;
    }
    /**
     * Set CheckedQuantity value
     * @param float $checkedQuantity
     * @return \StructType\GoodsInAdviceDetailRequest
     */
    public function setCheckedQuantity($checkedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($checkedQuantity) && !(is_float($checkedQuantity) || is_numeric($checkedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($checkedQuantity, true), gettype($checkedQuantity)), __LINE__);
        }
        $this->CheckedQuantity = $checkedQuantity;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\GoodsInAdviceDetailRequest
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
}
