<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIbtsRequest StructType
 * @subpackage Structs
 */
class GetIbtsRequest extends AbstractStructBase
{
    /**
     * The SenderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SenderNo;
    /**
     * The ReceiverNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiverNo;
    /**
     * The ChangedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedAt;
    /**
     * The IbtStatusesToSelect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IbtStatusesToSelect;
    /**
     * The IbtNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IbtNo;
    /**
     * The FLTPAToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FLTPAToken;
    /**
     * Constructor method for GetIbtsRequest
     * @uses GetIbtsRequest::setSenderNo()
     * @uses GetIbtsRequest::setReceiverNo()
     * @uses GetIbtsRequest::setChangedAt()
     * @uses GetIbtsRequest::setIbtStatusesToSelect()
     * @uses GetIbtsRequest::setIbtNo()
     * @uses GetIbtsRequest::setFLTPAToken()
     * @param int $senderNo
     * @param int $receiverNo
     * @param string $changedAt
     * @param string $ibtStatusesToSelect
     * @param string $ibtNo
     * @param string $fLTPAToken
     */
    public function __construct($senderNo = null, $receiverNo = null, $changedAt = null, $ibtStatusesToSelect = null, $ibtNo = null, $fLTPAToken = null)
    {
        $this
            ->setSenderNo($senderNo)
            ->setReceiverNo($receiverNo)
            ->setChangedAt($changedAt)
            ->setIbtStatusesToSelect($ibtStatusesToSelect)
            ->setIbtNo($ibtNo)
            ->setFLTPAToken($fLTPAToken);
    }
    /**
     * Get SenderNo value
     * @return int
     */
    public function getSenderNo()
    {
        return $this->SenderNo;
    }
    /**
     * Set SenderNo value
     * @param int $senderNo
     * @return \StructType\GetIbtsRequest
     */
    public function setSenderNo($senderNo = null)
    {
        // validation for constraint: int
        if (!is_null($senderNo) && !(is_int($senderNo) || ctype_digit($senderNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderNo, true), gettype($senderNo)), __LINE__);
        }
        $this->SenderNo = $senderNo;
        return $this;
    }
    /**
     * Get ReceiverNo value
     * @return int
     */
    public function getReceiverNo()
    {
        return $this->ReceiverNo;
    }
    /**
     * Set ReceiverNo value
     * @param int $receiverNo
     * @return \StructType\GetIbtsRequest
     */
    public function setReceiverNo($receiverNo = null)
    {
        // validation for constraint: int
        if (!is_null($receiverNo) && !(is_int($receiverNo) || ctype_digit($receiverNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiverNo, true), gettype($receiverNo)), __LINE__);
        }
        $this->ReceiverNo = $receiverNo;
        return $this;
    }
    /**
     * Get ChangedAt value
     * @return string
     */
    public function getChangedAt()
    {
        return $this->ChangedAt;
    }
    /**
     * Set ChangedAt value
     * @param string $changedAt
     * @return \StructType\GetIbtsRequest
     */
    public function setChangedAt($changedAt = null)
    {
        // validation for constraint: string
        if (!is_null($changedAt) && !is_string($changedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedAt, true), gettype($changedAt)), __LINE__);
        }
        $this->ChangedAt = $changedAt;
        return $this;
    }
    /**
     * Get IbtStatusesToSelect value
     * @return string
     */
    public function getIbtStatusesToSelect()
    {
        return $this->IbtStatusesToSelect;
    }
    /**
     * Set IbtStatusesToSelect value
     * @uses \EnumType\IbtStatusesToSelect::valueIsValid()
     * @uses \EnumType\IbtStatusesToSelect::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ibtStatusesToSelect
     * @return \StructType\GetIbtsRequest
     */
    public function setIbtStatusesToSelect($ibtStatusesToSelect = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IbtStatusesToSelect::valueIsValid($ibtStatusesToSelect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IbtStatusesToSelect', is_array($ibtStatusesToSelect) ? implode(', ', $ibtStatusesToSelect) : var_export($ibtStatusesToSelect, true), implode(', ', \EnumType\IbtStatusesToSelect::getValidValues())), __LINE__);
        }
        $this->IbtStatusesToSelect = $ibtStatusesToSelect;
        return $this;
    }
    /**
     * Get IbtNo value
     * @return string|null
     */
    public function getIbtNo()
    {
        return $this->IbtNo;
    }
    /**
     * Set IbtNo value
     * @param string $ibtNo
     * @return \StructType\GetIbtsRequest
     */
    public function setIbtNo($ibtNo = null)
    {
        // validation for constraint: string
        if (!is_null($ibtNo) && !is_string($ibtNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ibtNo, true), gettype($ibtNo)), __LINE__);
        }
        $this->IbtNo = $ibtNo;
        return $this;
    }
    /**
     * Get FLTPAToken value
     * @return string|null
     */
    public function getFLTPAToken()
    {
        return $this->FLTPAToken;
    }
    /**
     * Set FLTPAToken value
     * @param string $fLTPAToken
     * @return \StructType\GetIbtsRequest
     */
    public function setFLTPAToken($fLTPAToken = null)
    {
        // validation for constraint: string
        if (!is_null($fLTPAToken) && !is_string($fLTPAToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fLTPAToken, true), gettype($fLTPAToken)), __LINE__);
        }
        $this->FLTPAToken = $fLTPAToken;
        return $this;
    }
}
