<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindCustomersByParameterRequest StructType
 * @subpackage Structs
 */
class FindCustomersByParameterRequest extends AbstractStructBase
{
    /**
     * The SearchParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SearchParameter;
    /**
     * The SearchValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchValue;
    /**
     * The AdditionalSearchInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalSearchInfo;
    /**
     * Constructor method for FindCustomersByParameterRequest
     * @uses FindCustomersByParameterRequest::setSearchParameter()
     * @uses FindCustomersByParameterRequest::setSearchValue()
     * @uses FindCustomersByParameterRequest::setAdditionalSearchInfo()
     * @param string $searchParameter
     * @param string $searchValue
     * @param string $additionalSearchInfo
     */
    public function __construct($searchParameter = null, $searchValue = null, $additionalSearchInfo = null)
    {
        $this
            ->setSearchParameter($searchParameter)
            ->setSearchValue($searchValue)
            ->setAdditionalSearchInfo($additionalSearchInfo);
    }
    /**
     * Get SearchParameter value
     * @return string
     */
    public function getSearchParameter()
    {
        return $this->SearchParameter;
    }
    /**
     * Set SearchParameter value
     * @uses \EnumType\CustomersSearchParameter::valueIsValid()
     * @uses \EnumType\CustomersSearchParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchParameter
     * @return \StructType\FindCustomersByParameterRequest
     */
    public function setSearchParameter($searchParameter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomersSearchParameter::valueIsValid($searchParameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomersSearchParameter', is_array($searchParameter) ? implode(', ', $searchParameter) : var_export($searchParameter, true), implode(', ', \EnumType\CustomersSearchParameter::getValidValues())), __LINE__);
        }
        $this->SearchParameter = $searchParameter;
        return $this;
    }
    /**
     * Get SearchValue value
     * @return string|null
     */
    public function getSearchValue()
    {
        return $this->SearchValue;
    }
    /**
     * Set SearchValue value
     * @param string $searchValue
     * @return \StructType\FindCustomersByParameterRequest
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue) && !is_string($searchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->SearchValue = $searchValue;
        return $this;
    }
    /**
     * Get AdditionalSearchInfo value
     * @return string|null
     */
    public function getAdditionalSearchInfo()
    {
        return $this->AdditionalSearchInfo;
    }
    /**
     * Set AdditionalSearchInfo value
     * @param string $additionalSearchInfo
     * @return \StructType\FindCustomersByParameterRequest
     */
    public function setAdditionalSearchInfo($additionalSearchInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalSearchInfo) && !is_string($additionalSearchInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalSearchInfo, true), gettype($additionalSearchInfo)), __LINE__);
        }
        $this->AdditionalSearchInfo = $additionalSearchInfo;
        return $this;
    }
}
