<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindCustomerRequest StructType
 * @subpackage Structs
 */
class FindCustomerRequest extends AbstractStructBase
{
    /**
     * The CustomerOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerOid;
    /**
     * Constructor method for FindCustomerRequest
     * @uses FindCustomerRequest::setCustomerOid()
     * @param string $customerOid
     */
    public function __construct($customerOid = null)
    {
        $this
            ->setCustomerOid($customerOid);
    }
    /**
     * Get CustomerOid value
     * @return string|null
     */
    public function getCustomerOid()
    {
        return $this->CustomerOid;
    }
    /**
     * Set CustomerOid value
     * @param string $customerOid
     * @return \StructType\FindCustomerRequest
     */
    public function setCustomerOid($customerOid = null)
    {
        // validation for constraint: string
        if (!is_null($customerOid) && !is_string($customerOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerOid, true), gettype($customerOid)), __LINE__);
        }
        $this->CustomerOid = $customerOid;
        return $this;
    }
}
