<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee StructType
 * @subpackage Structs
 */
class Employee extends BaseContract_FullIDSet
{
    /**
     * The IsSalesPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSalesPerson;
    /**
     * The IsFormerEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFormerEmployee;
    /**
     * The ChangedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedAt;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerReference
     */
    public $CustomerReference;
    /**
     * The OrgMemberId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgMemberId;
    /**
     * Constructor method for Employee
     * @uses Employee::setIsSalesPerson()
     * @uses Employee::setIsFormerEmployee()
     * @uses Employee::setChangedAt()
     * @uses Employee::setDescription()
     * @uses Employee::setPassword()
     * @uses Employee::setPerson()
     * @uses Employee::setCustomerReference()
     * @uses Employee::setOrgMemberId()
     * @param bool $isSalesPerson
     * @param bool $isFormerEmployee
     * @param string $changedAt
     * @param string $description
     * @param string $password
     * @param \StructType\Person $person
     * @param \StructType\CustomerReference $customerReference
     * @param string $orgMemberId
     */
    public function __construct($isSalesPerson = null, $isFormerEmployee = null, $changedAt = null, $description = null, $password = null, \StructType\Person $person = null, \StructType\CustomerReference $customerReference = null, $orgMemberId = null)
    {
        $this
            ->setIsSalesPerson($isSalesPerson)
            ->setIsFormerEmployee($isFormerEmployee)
            ->setChangedAt($changedAt)
            ->setDescription($description)
            ->setPassword($password)
            ->setPerson($person)
            ->setCustomerReference($customerReference)
            ->setOrgMemberId($orgMemberId);
    }
    /**
     * Get IsSalesPerson value
     * @return bool
     */
    public function getIsSalesPerson()
    {
        return $this->IsSalesPerson;
    }
    /**
     * Set IsSalesPerson value
     * @param bool $isSalesPerson
     * @return \StructType\Employee
     */
    public function setIsSalesPerson($isSalesPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesPerson) && !is_bool($isSalesPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesPerson, true), gettype($isSalesPerson)), __LINE__);
        }
        $this->IsSalesPerson = $isSalesPerson;
        return $this;
    }
    /**
     * Get IsFormerEmployee value
     * @return bool
     */
    public function getIsFormerEmployee()
    {
        return $this->IsFormerEmployee;
    }
    /**
     * Set IsFormerEmployee value
     * @param bool $isFormerEmployee
     * @return \StructType\Employee
     */
    public function setIsFormerEmployee($isFormerEmployee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFormerEmployee) && !is_bool($isFormerEmployee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFormerEmployee, true), gettype($isFormerEmployee)), __LINE__);
        }
        $this->IsFormerEmployee = $isFormerEmployee;
        return $this;
    }
    /**
     * Get ChangedAt value
     * @return string
     */
    public function getChangedAt()
    {
        return $this->ChangedAt;
    }
    /**
     * Set ChangedAt value
     * @param string $changedAt
     * @return \StructType\Employee
     */
    public function setChangedAt($changedAt = null)
    {
        // validation for constraint: string
        if (!is_null($changedAt) && !is_string($changedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedAt, true), gettype($changedAt)), __LINE__);
        }
        $this->ChangedAt = $changedAt;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Employee
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Employee
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\Employee
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return \StructType\CustomerReference|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param \StructType\CustomerReference $customerReference
     * @return \StructType\Employee
     */
    public function setCustomerReference(\StructType\CustomerReference $customerReference = null)
    {
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get OrgMemberId value
     * @return string|null
     */
    public function getOrgMemberId()
    {
        return $this->OrgMemberId;
    }
    /**
     * Set OrgMemberId value
     * @param string $orgMemberId
     * @return \StructType\Employee
     */
    public function setOrgMemberId($orgMemberId = null)
    {
        // validation for constraint: string
        if (!is_null($orgMemberId) && !is_string($orgMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgMemberId, true), gettype($orgMemberId)), __LINE__);
        }
        $this->OrgMemberId = $orgMemberId;
        return $this;
    }
}
