<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryNote StructType
 * @subpackage Structs
 */
class DeliveryNote extends BaseContract_FullIDSet
{
    /**
     * The LastChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastChange;
    /**
     * The DeliveryNoteType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryNoteType;
    /**
     * The DeliveryNoteTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryNoteTimestamp;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The Originator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Originator;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient;
    /**
     * The DeliveryNotePositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeliveryNotePosition
     */
    public $DeliveryNotePositions;
    /**
     * Constructor method for DeliveryNote
     * @uses DeliveryNote::setLastChange()
     * @uses DeliveryNote::setDeliveryNoteType()
     * @uses DeliveryNote::setDeliveryNoteTimestamp()
     * @uses DeliveryNote::setOrderId()
     * @uses DeliveryNote::setBranchId()
     * @uses DeliveryNote::setShopId()
     * @uses DeliveryNote::setCustomerId()
     * @uses DeliveryNote::setShopCustomerId()
     * @uses DeliveryNote::setOriginator()
     * @uses DeliveryNote::setRecipient()
     * @uses DeliveryNote::setDeliveryNotePositions()
     * @param string $lastChange
     * @param string $deliveryNoteType
     * @param string $deliveryNoteTimestamp
     * @param string $orderId
     * @param string $branchId
     * @param string $shopId
     * @param string $customerId
     * @param string $shopCustomerId
     * @param string $originator
     * @param string $recipient
     * @param \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions
     */
    public function __construct($lastChange = null, $deliveryNoteType = null, $deliveryNoteTimestamp = null, $orderId = null, $branchId = null, $shopId = null, $customerId = null, $shopCustomerId = null, $originator = null, $recipient = null, \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions = null)
    {
        $this
            ->setLastChange($lastChange)
            ->setDeliveryNoteType($deliveryNoteType)
            ->setDeliveryNoteTimestamp($deliveryNoteTimestamp)
            ->setOrderId($orderId)
            ->setBranchId($branchId)
            ->setShopId($shopId)
            ->setCustomerId($customerId)
            ->setShopCustomerId($shopCustomerId)
            ->setOriginator($originator)
            ->setRecipient($recipient)
            ->setDeliveryNotePositions($deliveryNotePositions);
    }
    /**
     * Get LastChange value
     * @return string
     */
    public function getLastChange()
    {
        return $this->LastChange;
    }
    /**
     * Set LastChange value
     * @param string $lastChange
     * @return \StructType\DeliveryNote
     */
    public function setLastChange($lastChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastChange) && !is_string($lastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChange, true), gettype($lastChange)), __LINE__);
        }
        $this->LastChange = $lastChange;
        return $this;
    }
    /**
     * Get DeliveryNoteType value
     * @return string
     */
    public function getDeliveryNoteType()
    {
        return $this->DeliveryNoteType;
    }
    /**
     * Set DeliveryNoteType value
     * @uses \EnumType\DeliveryNoteType::valueIsValid()
     * @uses \EnumType\DeliveryNoteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryNoteType
     * @return \StructType\DeliveryNote
     */
    public function setDeliveryNoteType($deliveryNoteType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryNoteType::valueIsValid($deliveryNoteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryNoteType', is_array($deliveryNoteType) ? implode(', ', $deliveryNoteType) : var_export($deliveryNoteType, true), implode(', ', \EnumType\DeliveryNoteType::getValidValues())), __LINE__);
        }
        $this->DeliveryNoteType = $deliveryNoteType;
        return $this;
    }
    /**
     * Get DeliveryNoteTimestamp value
     * @return string
     */
    public function getDeliveryNoteTimestamp()
    {
        return $this->DeliveryNoteTimestamp;
    }
    /**
     * Set DeliveryNoteTimestamp value
     * @param string $deliveryNoteTimestamp
     * @return \StructType\DeliveryNote
     */
    public function setDeliveryNoteTimestamp($deliveryNoteTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteTimestamp) && !is_string($deliveryNoteTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteTimestamp, true), gettype($deliveryNoteTimestamp)), __LINE__);
        }
        $this->DeliveryNoteTimestamp = $deliveryNoteTimestamp;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\DeliveryNote
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\DeliveryNote
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\DeliveryNote
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\DeliveryNote
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\DeliveryNote
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get Originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->Originator;
    }
    /**
     * Set Originator value
     * @param string $originator
     * @return \StructType\DeliveryNote
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        $this->Originator = $originator;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \StructType\DeliveryNote
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get DeliveryNotePositions value
     * @return \ArrayType\ArrayOfDeliveryNotePosition|null
     */
    public function getDeliveryNotePositions()
    {
        return $this->DeliveryNotePositions;
    }
    /**
     * Set DeliveryNotePositions value
     * @param \ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions
     * @return \StructType\DeliveryNote
     */
    public function setDeliveryNotePositions(\ArrayType\ArrayOfDeliveryNotePosition $deliveryNotePositions = null)
    {
        $this->DeliveryNotePositions = $deliveryNotePositions;
        return $this;
    }
}
