<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletedObjectsIterationResponse StructType
 * @subpackage Structs
 */
class DeletedObjectsIterationResponse extends BaseIterationResponse
{
    /**
     * The StatusMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The DeletedObjectReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeletedObjectReference
     */
    public $DeletedObjectReferences;
    /**
     * Constructor method for DeletedObjectsIterationResponse
     * @uses DeletedObjectsIterationResponse::setStatusMessage()
     * @uses DeletedObjectsIterationResponse::setDeletedObjectReferences()
     * @param string $statusMessage
     * @param \ArrayType\ArrayOfDeletedObjectReference $deletedObjectReferences
     */
    public function __construct($statusMessage = null, \ArrayType\ArrayOfDeletedObjectReference $deletedObjectReferences = null)
    {
        $this
            ->setStatusMessage($statusMessage)
            ->setDeletedObjectReferences($deletedObjectReferences);
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \StructType\DeletedObjectsIterationResponse
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get DeletedObjectReferences value
     * @return \ArrayType\ArrayOfDeletedObjectReference|null
     */
    public function getDeletedObjectReferences()
    {
        return $this->DeletedObjectReferences;
    }
    /**
     * Set DeletedObjectReferences value
     * @param \ArrayType\ArrayOfDeletedObjectReference $deletedObjectReferences
     * @return \StructType\DeletedObjectsIterationResponse
     */
    public function setDeletedObjectReferences(\ArrayType\ArrayOfDeletedObjectReference $deletedObjectReferences = null)
    {
        $this->DeletedObjectReferences = $deletedObjectReferences;
        return $this;
    }
}
