<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletedObjectsIterationRequest StructType
 * @subpackage Structs
 */
class DeletedObjectsIterationRequest extends BaseIterationRequest
{
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The RecordId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecordId;
    /**
     * Constructor method for DeletedObjectsIterationRequest
     * @uses DeletedObjectsIterationRequest::setChangedSinceDate()
     * @uses DeletedObjectsIterationRequest::setRecordId()
     * @param string $changedSinceDate
     * @param string $recordId
     */
    public function __construct($changedSinceDate = null, $recordId = null)
    {
        $this
            ->setChangedSinceDate($changedSinceDate)
            ->setRecordId($recordId);
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\DeletedObjectsIterationRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get RecordId value
     * @return string|null
     */
    public function getRecordId()
    {
        return $this->RecordId;
    }
    /**
     * Set RecordId value
     * @param string $recordId
     * @return \StructType\DeletedObjectsIterationRequest
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        $this->RecordId = $recordId;
        return $this;
    }
}
