<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPurchaseHistoryRequest StructType
 * @subpackage Structs
 */
class CustomerPurchaseHistoryRequest extends BaseIterationRequest
{
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTo;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for CustomerPurchaseHistoryRequest
     * @uses CustomerPurchaseHistoryRequest::setDateFrom()
     * @uses CustomerPurchaseHistoryRequest::setDateTo()
     * @uses CustomerPurchaseHistoryRequest::setCustomerId()
     * @param string $dateFrom
     * @param string $dateTo
     * @param string $customerId
     */
    public function __construct($dateFrom = null, $dateTo = null, $customerId = null)
    {
        $this
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setCustomerId($customerId);
    }
    /**
     * Get DateFrom value
     * @return string
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \StructType\CustomerPurchaseHistoryRequest
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \StructType\CustomerPurchaseHistoryRequest
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\CustomerPurchaseHistoryRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
