<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends BaseContract_FullIDSet
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The ChangedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedAt;
    /**
     * The StandardDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StandardDiscount;
    /**
     * The IsReseller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReseller;
    /**
     * The WithoutVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WithoutVAT;
    /**
     * The Blocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Blocked;
    /**
     * The BlockedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BlockedSinceDate;
    /**
     * The BonusPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BonusPoints;
    /**
     * The BonusSaleReduced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonusSaleReduced;
    /**
     * The BonusSaleRegular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonusSaleRegular;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DefaultCurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultCurrencyISO;
    /**
     * The DefaultPaymentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultPaymentTypeId;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The HomeBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomeBranchId;
    /**
     * The CreatedByEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByEmployee;
    /**
     * The CreatedAtPos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedAtPos;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentId;
    /**
     * The Characteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCharacteristic
     */
    public $Characteristics;
    /**
     * The PreferredCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreferredCommunication;
    /**
     * The VATId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VATId;
    /**
     * Constructor method for Customer
     * @uses Customer::setCreationDate()
     * @uses Customer::setChangedAt()
     * @uses Customer::setStandardDiscount()
     * @uses Customer::setIsReseller()
     * @uses Customer::setWithoutVAT()
     * @uses Customer::setBlocked()
     * @uses Customer::setBlockedSinceDate()
     * @uses Customer::setBonusPoints()
     * @uses Customer::setBonusSaleReduced()
     * @uses Customer::setBonusSaleRegular()
     * @uses Customer::setShopId()
     * @uses Customer::setShopCustomerId()
     * @uses Customer::setDescription()
     * @uses Customer::setDefaultCurrencyISO()
     * @uses Customer::setDefaultPaymentTypeId()
     * @uses Customer::setPerson()
     * @uses Customer::setHomeBranchId()
     * @uses Customer::setCreatedByEmployee()
     * @uses Customer::setCreatedAtPos()
     * @uses Customer::setParentId()
     * @uses Customer::setCharacteristics()
     * @uses Customer::setPreferredCommunication()
     * @uses Customer::setVATId()
     * @param string $creationDate
     * @param string $changedAt
     * @param float $standardDiscount
     * @param bool $isReseller
     * @param bool $withoutVAT
     * @param bool $blocked
     * @param string $blockedSinceDate
     * @param int $bonusPoints
     * @param float $bonusSaleReduced
     * @param float $bonusSaleRegular
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $description
     * @param string $defaultCurrencyISO
     * @param string $defaultPaymentTypeId
     * @param \StructType\Person $person
     * @param string $homeBranchId
     * @param string $createdByEmployee
     * @param string $createdAtPos
     * @param string $parentId
     * @param \ArrayType\ArrayOfCharacteristic $characteristics
     * @param string $preferredCommunication
     * @param string $vATId
     */
    public function __construct($creationDate = null, $changedAt = null, $standardDiscount = null, $isReseller = null, $withoutVAT = null, $blocked = null, $blockedSinceDate = null, $bonusPoints = null, $bonusSaleReduced = null, $bonusSaleRegular = null, $shopId = null, $shopCustomerId = null, $description = null, $defaultCurrencyISO = null, $defaultPaymentTypeId = null, \StructType\Person $person = null, $homeBranchId = null, $createdByEmployee = null, $createdAtPos = null, $parentId = null, \ArrayType\ArrayOfCharacteristic $characteristics = null, $preferredCommunication = null, $vATId = null)
    {
        $this
            ->setCreationDate($creationDate)
            ->setChangedAt($changedAt)
            ->setStandardDiscount($standardDiscount)
            ->setIsReseller($isReseller)
            ->setWithoutVAT($withoutVAT)
            ->setBlocked($blocked)
            ->setBlockedSinceDate($blockedSinceDate)
            ->setBonusPoints($bonusPoints)
            ->setBonusSaleReduced($bonusSaleReduced)
            ->setBonusSaleRegular($bonusSaleRegular)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setDescription($description)
            ->setDefaultCurrencyISO($defaultCurrencyISO)
            ->setDefaultPaymentTypeId($defaultPaymentTypeId)
            ->setPerson($person)
            ->setHomeBranchId($homeBranchId)
            ->setCreatedByEmployee($createdByEmployee)
            ->setCreatedAtPos($createdAtPos)
            ->setParentId($parentId)
            ->setCharacteristics($characteristics)
            ->setPreferredCommunication($preferredCommunication)
            ->setVATId($vATId);
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Customer
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ChangedAt value
     * @return string
     */
    public function getChangedAt()
    {
        return $this->ChangedAt;
    }
    /**
     * Set ChangedAt value
     * @param string $changedAt
     * @return \StructType\Customer
     */
    public function setChangedAt($changedAt = null)
    {
        // validation for constraint: string
        if (!is_null($changedAt) && !is_string($changedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedAt, true), gettype($changedAt)), __LINE__);
        }
        $this->ChangedAt = $changedAt;
        return $this;
    }
    /**
     * Get StandardDiscount value
     * @return float
     */
    public function getStandardDiscount()
    {
        return $this->StandardDiscount;
    }
    /**
     * Set StandardDiscount value
     * @param float $standardDiscount
     * @return \StructType\Customer
     */
    public function setStandardDiscount($standardDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($standardDiscount) && !(is_float($standardDiscount) || is_numeric($standardDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardDiscount, true), gettype($standardDiscount)), __LINE__);
        }
        $this->StandardDiscount = $standardDiscount;
        return $this;
    }
    /**
     * Get IsReseller value
     * @return bool
     */
    public function getIsReseller()
    {
        return $this->IsReseller;
    }
    /**
     * Set IsReseller value
     * @param bool $isReseller
     * @return \StructType\Customer
     */
    public function setIsReseller($isReseller = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReseller) && !is_bool($isReseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReseller, true), gettype($isReseller)), __LINE__);
        }
        $this->IsReseller = $isReseller;
        return $this;
    }
    /**
     * Get WithoutVAT value
     * @return bool
     */
    public function getWithoutVAT()
    {
        return $this->WithoutVAT;
    }
    /**
     * Set WithoutVAT value
     * @param bool $withoutVAT
     * @return \StructType\Customer
     */
    public function setWithoutVAT($withoutVAT = null)
    {
        // validation for constraint: boolean
        if (!is_null($withoutVAT) && !is_bool($withoutVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutVAT, true), gettype($withoutVAT)), __LINE__);
        }
        $this->WithoutVAT = $withoutVAT;
        return $this;
    }
    /**
     * Get Blocked value
     * @return bool
     */
    public function getBlocked()
    {
        return $this->Blocked;
    }
    /**
     * Set Blocked value
     * @param bool $blocked
     * @return \StructType\Customer
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($blocked) && !is_bool($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        $this->Blocked = $blocked;
        return $this;
    }
    /**
     * Get BlockedSinceDate value
     * @return string
     */
    public function getBlockedSinceDate()
    {
        return $this->BlockedSinceDate;
    }
    /**
     * Set BlockedSinceDate value
     * @param string $blockedSinceDate
     * @return \StructType\Customer
     */
    public function setBlockedSinceDate($blockedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($blockedSinceDate) && !is_string($blockedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockedSinceDate, true), gettype($blockedSinceDate)), __LINE__);
        }
        $this->BlockedSinceDate = $blockedSinceDate;
        return $this;
    }
    /**
     * Get BonusPoints value
     * @return int
     */
    public function getBonusPoints()
    {
        return $this->BonusPoints;
    }
    /**
     * Set BonusPoints value
     * @param int $bonusPoints
     * @return \StructType\Customer
     */
    public function setBonusPoints($bonusPoints = null)
    {
        // validation for constraint: int
        if (!is_null($bonusPoints) && !(is_int($bonusPoints) || ctype_digit($bonusPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusPoints, true), gettype($bonusPoints)), __LINE__);
        }
        $this->BonusPoints = $bonusPoints;
        return $this;
    }
    /**
     * Get BonusSaleReduced value
     * @return float
     */
    public function getBonusSaleReduced()
    {
        return $this->BonusSaleReduced;
    }
    /**
     * Set BonusSaleReduced value
     * @param float $bonusSaleReduced
     * @return \StructType\Customer
     */
    public function setBonusSaleReduced($bonusSaleReduced = null)
    {
        // validation for constraint: float
        if (!is_null($bonusSaleReduced) && !(is_float($bonusSaleReduced) || is_numeric($bonusSaleReduced))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusSaleReduced, true), gettype($bonusSaleReduced)), __LINE__);
        }
        $this->BonusSaleReduced = $bonusSaleReduced;
        return $this;
    }
    /**
     * Get BonusSaleRegular value
     * @return float
     */
    public function getBonusSaleRegular()
    {
        return $this->BonusSaleRegular;
    }
    /**
     * Set BonusSaleRegular value
     * @param float $bonusSaleRegular
     * @return \StructType\Customer
     */
    public function setBonusSaleRegular($bonusSaleRegular = null)
    {
        // validation for constraint: float
        if (!is_null($bonusSaleRegular) && !(is_float($bonusSaleRegular) || is_numeric($bonusSaleRegular))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusSaleRegular, true), gettype($bonusSaleRegular)), __LINE__);
        }
        $this->BonusSaleRegular = $bonusSaleRegular;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\Customer
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\Customer
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Customer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DefaultCurrencyISO value
     * @return string|null
     */
    public function getDefaultCurrencyISO()
    {
        return $this->DefaultCurrencyISO;
    }
    /**
     * Set DefaultCurrencyISO value
     * @param string $defaultCurrencyISO
     * @return \StructType\Customer
     */
    public function setDefaultCurrencyISO($defaultCurrencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCurrencyISO) && !is_string($defaultCurrencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCurrencyISO, true), gettype($defaultCurrencyISO)), __LINE__);
        }
        $this->DefaultCurrencyISO = $defaultCurrencyISO;
        return $this;
    }
    /**
     * Get DefaultPaymentTypeId value
     * @return string|null
     */
    public function getDefaultPaymentTypeId()
    {
        return $this->DefaultPaymentTypeId;
    }
    /**
     * Set DefaultPaymentTypeId value
     * @param string $defaultPaymentTypeId
     * @return \StructType\Customer
     */
    public function setDefaultPaymentTypeId($defaultPaymentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPaymentTypeId) && !is_string($defaultPaymentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPaymentTypeId, true), gettype($defaultPaymentTypeId)), __LINE__);
        }
        $this->DefaultPaymentTypeId = $defaultPaymentTypeId;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\Customer
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get HomeBranchId value
     * @return string|null
     */
    public function getHomeBranchId()
    {
        return $this->HomeBranchId;
    }
    /**
     * Set HomeBranchId value
     * @param string $homeBranchId
     * @return \StructType\Customer
     */
    public function setHomeBranchId($homeBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($homeBranchId) && !is_string($homeBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeBranchId, true), gettype($homeBranchId)), __LINE__);
        }
        $this->HomeBranchId = $homeBranchId;
        return $this;
    }
    /**
     * Get CreatedByEmployee value
     * @return string|null
     */
    public function getCreatedByEmployee()
    {
        return $this->CreatedByEmployee;
    }
    /**
     * Set CreatedByEmployee value
     * @param string $createdByEmployee
     * @return \StructType\Customer
     */
    public function setCreatedByEmployee($createdByEmployee = null)
    {
        // validation for constraint: string
        if (!is_null($createdByEmployee) && !is_string($createdByEmployee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByEmployee, true), gettype($createdByEmployee)), __LINE__);
        }
        $this->CreatedByEmployee = $createdByEmployee;
        return $this;
    }
    /**
     * Get CreatedAtPos value
     * @return string|null
     */
    public function getCreatedAtPos()
    {
        return $this->CreatedAtPos;
    }
    /**
     * Set CreatedAtPos value
     * @param string $createdAtPos
     * @return \StructType\Customer
     */
    public function setCreatedAtPos($createdAtPos = null)
    {
        // validation for constraint: string
        if (!is_null($createdAtPos) && !is_string($createdAtPos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAtPos, true), gettype($createdAtPos)), __LINE__);
        }
        $this->CreatedAtPos = $createdAtPos;
        return $this;
    }
    /**
     * Get ParentId value
     * @return string|null
     */
    public function getParentId()
    {
        return $this->ParentId;
    }
    /**
     * Set ParentId value
     * @param string $parentId
     * @return \StructType\Customer
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        $this->ParentId = $parentId;
        return $this;
    }
    /**
     * Get Characteristics value
     * @return \ArrayType\ArrayOfCharacteristic|null
     */
    public function getCharacteristics()
    {
        return $this->Characteristics;
    }
    /**
     * Set Characteristics value
     * @param \ArrayType\ArrayOfCharacteristic $characteristics
     * @return \StructType\Customer
     */
    public function setCharacteristics(\ArrayType\ArrayOfCharacteristic $characteristics = null)
    {
        $this->Characteristics = $characteristics;
        return $this;
    }
    /**
     * Get PreferredCommunication value
     * @return string|null
     */
    public function getPreferredCommunication()
    {
        return $this->PreferredCommunication;
    }
    /**
     * Set PreferredCommunication value
     * @param string $preferredCommunication
     * @return \StructType\Customer
     */
    public function setPreferredCommunication($preferredCommunication = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCommunication) && !is_string($preferredCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCommunication, true), gettype($preferredCommunication)), __LINE__);
        }
        $this->PreferredCommunication = $preferredCommunication;
        return $this;
    }
    /**
     * Get VATId value
     * @return string|null
     */
    public function getVATId()
    {
        return $this->VATId;
    }
    /**
     * Set VATId value
     * @param string $vATId
     * @return \StructType\Customer
     */
    public function setVATId($vATId = null)
    {
        // validation for constraint: string
        if (!is_null($vATId) && !is_string($vATId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vATId, true), gettype($vATId)), __LINE__);
        }
        $this->VATId = $vATId;
        return $this;
    }
}
