<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Color StructType
 * @subpackage Structs
 */
class Color extends AbstractStructBase
{
    /**
     * The SystemColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemColorId;
    /**
     * The ManufacturerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerId;
    /**
     * The ManufacturerOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerOid;
    /**
     * The ManufacturerDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerDescription;
    /**
     * The SystemColorOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemColorOid;
    /**
     * The SystemColorDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemColorDescription;
    /**
     * Constructor method for Color
     * @uses Color::setSystemColorId()
     * @uses Color::setManufacturerId()
     * @uses Color::setManufacturerOid()
     * @uses Color::setManufacturerDescription()
     * @uses Color::setSystemColorOid()
     * @uses Color::setSystemColorDescription()
     * @param int $systemColorId
     * @param string $manufacturerId
     * @param string $manufacturerOid
     * @param string $manufacturerDescription
     * @param string $systemColorOid
     * @param string $systemColorDescription
     */
    public function __construct($systemColorId = null, $manufacturerId = null, $manufacturerOid = null, $manufacturerDescription = null, $systemColorOid = null, $systemColorDescription = null)
    {
        $this
            ->setSystemColorId($systemColorId)
            ->setManufacturerId($manufacturerId)
            ->setManufacturerOid($manufacturerOid)
            ->setManufacturerDescription($manufacturerDescription)
            ->setSystemColorOid($systemColorOid)
            ->setSystemColorDescription($systemColorDescription);
    }
    /**
     * Get SystemColorId value
     * @return int
     */
    public function getSystemColorId()
    {
        return $this->SystemColorId;
    }
    /**
     * Set SystemColorId value
     * @param int $systemColorId
     * @return \StructType\Color
     */
    public function setSystemColorId($systemColorId = null)
    {
        // validation for constraint: int
        if (!is_null($systemColorId) && !(is_int($systemColorId) || ctype_digit($systemColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemColorId, true), gettype($systemColorId)), __LINE__);
        }
        $this->SystemColorId = $systemColorId;
        return $this;
    }
    /**
     * Get ManufacturerId value
     * @return string|null
     */
    public function getManufacturerId()
    {
        return $this->ManufacturerId;
    }
    /**
     * Set ManufacturerId value
     * @param string $manufacturerId
     * @return \StructType\Color
     */
    public function setManufacturerId($manufacturerId = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerId) && !is_string($manufacturerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerId, true), gettype($manufacturerId)), __LINE__);
        }
        $this->ManufacturerId = $manufacturerId;
        return $this;
    }
    /**
     * Get ManufacturerOid value
     * @return string|null
     */
    public function getManufacturerOid()
    {
        return $this->ManufacturerOid;
    }
    /**
     * Set ManufacturerOid value
     * @param string $manufacturerOid
     * @return \StructType\Color
     */
    public function setManufacturerOid($manufacturerOid = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerOid) && !is_string($manufacturerOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerOid, true), gettype($manufacturerOid)), __LINE__);
        }
        $this->ManufacturerOid = $manufacturerOid;
        return $this;
    }
    /**
     * Get ManufacturerDescription value
     * @return string|null
     */
    public function getManufacturerDescription()
    {
        return $this->ManufacturerDescription;
    }
    /**
     * Set ManufacturerDescription value
     * @param string $manufacturerDescription
     * @return \StructType\Color
     */
    public function setManufacturerDescription($manufacturerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerDescription) && !is_string($manufacturerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerDescription, true), gettype($manufacturerDescription)), __LINE__);
        }
        $this->ManufacturerDescription = $manufacturerDescription;
        return $this;
    }
    /**
     * Get SystemColorOid value
     * @return string|null
     */
    public function getSystemColorOid()
    {
        return $this->SystemColorOid;
    }
    /**
     * Set SystemColorOid value
     * @param string $systemColorOid
     * @return \StructType\Color
     */
    public function setSystemColorOid($systemColorOid = null)
    {
        // validation for constraint: string
        if (!is_null($systemColorOid) && !is_string($systemColorOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemColorOid, true), gettype($systemColorOid)), __LINE__);
        }
        $this->SystemColorOid = $systemColorOid;
        return $this;
    }
    /**
     * Get SystemColorDescription value
     * @return string|null
     */
    public function getSystemColorDescription()
    {
        return $this->SystemColorDescription;
    }
    /**
     * Set SystemColorDescription value
     * @param string $systemColorDescription
     * @return \StructType\Color
     */
    public function setSystemColorDescription($systemColorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($systemColorDescription) && !is_string($systemColorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemColorDescription, true), gettype($systemColorDescription)), __LINE__);
        }
        $this->SystemColorDescription = $systemColorDescription;
        return $this;
    }
}
