<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchPrice StructType
 * @subpackage Structs
 */
class BranchPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The UnrealisticPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnrealisticPrice;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * Constructor method for BranchPrice
     * @uses BranchPrice::setPrice()
     * @uses BranchPrice::setUnrealisticPrice()
     * @uses BranchPrice::setBranchId()
     * @param float $price
     * @param float $unrealisticPrice
     * @param string $branchId
     */
    public function __construct($price = null, $unrealisticPrice = null, $branchId = null)
    {
        $this
            ->setPrice($price)
            ->setUnrealisticPrice($unrealisticPrice)
            ->setBranchId($branchId);
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\BranchPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get UnrealisticPrice value
     * @return float
     */
    public function getUnrealisticPrice()
    {
        return $this->UnrealisticPrice;
    }
    /**
     * Set UnrealisticPrice value
     * @param float $unrealisticPrice
     * @return \StructType\BranchPrice
     */
    public function setUnrealisticPrice($unrealisticPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unrealisticPrice) && !(is_float($unrealisticPrice) || is_numeric($unrealisticPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unrealisticPrice, true), gettype($unrealisticPrice)), __LINE__);
        }
        $this->UnrealisticPrice = $unrealisticPrice;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\BranchPrice
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
}
