<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The FLTPAToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FLTPAToken;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setExtensionData()
     * @uses BaseRequest::setFLTPAToken()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $fLTPAToken
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $fLTPAToken = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setFLTPAToken($fLTPAToken);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\BaseRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get FLTPAToken value
     * @return string|null
     */
    public function getFLTPAToken()
    {
        return $this->FLTPAToken;
    }
    /**
     * Set FLTPAToken value
     * @param string $fLTPAToken
     * @return \StructType\BaseRequest
     */
    public function setFLTPAToken($fLTPAToken = null)
    {
        // validation for constraint: string
        if (!is_null($fLTPAToken) && !is_string($fLTPAToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fLTPAToken, true), gettype($fLTPAToken)), __LINE__);
        }
        $this->FLTPAToken = $fLTPAToken;
        return $this;
    }
}
