<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArticleRequest StructType
 * @subpackage Structs
 */
class ArticleRequest extends BaseIterationRequest
{
    /**
     * The RequestPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestPriority;
    /**
     * The ResponseDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseDetails;
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleId;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The PriceBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceBranchId;
    /**
     * Constructor method for ArticleRequest
     * @uses ArticleRequest::setRequestPriority()
     * @uses ArticleRequest::setResponseDetails()
     * @uses ArticleRequest::setChangedSinceDate()
     * @uses ArticleRequest::setArticleId()
     * @uses ArticleRequest::setEAN()
     * @uses ArticleRequest::setPriceBranchId()
     * @param string $requestPriority
     * @param string $responseDetails
     * @param string $changedSinceDate
     * @param string $articleId
     * @param string $eAN
     * @param string $priceBranchId
     */
    public function __construct($requestPriority = null, $responseDetails = null, $changedSinceDate = null, $articleId = null, $eAN = null, $priceBranchId = null)
    {
        $this
            ->setRequestPriority($requestPriority)
            ->setResponseDetails($responseDetails)
            ->setChangedSinceDate($changedSinceDate)
            ->setArticleId($articleId)
            ->setEAN($eAN)
            ->setPriceBranchId($priceBranchId);
    }
    /**
     * Get RequestPriority value
     * @return string
     */
    public function getRequestPriority()
    {
        return $this->RequestPriority;
    }
    /**
     * Set RequestPriority value
     * @uses \EnumType\ArticleRequestPriority::valueIsValid()
     * @uses \EnumType\ArticleRequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestPriority
     * @return \StructType\ArticleRequest
     */
    public function setRequestPriority($requestPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArticleRequestPriority::valueIsValid($requestPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ArticleRequestPriority', is_array($requestPriority) ? implode(', ', $requestPriority) : var_export($requestPriority, true), implode(', ', \EnumType\ArticleRequestPriority::getValidValues())), __LINE__);
        }
        $this->RequestPriority = $requestPriority;
        return $this;
    }
    /**
     * Get ResponseDetails value
     * @return string
     */
    public function getResponseDetails()
    {
        return $this->ResponseDetails;
    }
    /**
     * Set ResponseDetails value
     * @uses \EnumType\ArticleResponseDetails::valueIsValid()
     * @uses \EnumType\ArticleResponseDetails::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseDetails
     * @return \StructType\ArticleRequest
     */
    public function setResponseDetails($responseDetails = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArticleResponseDetails::valueIsValid($responseDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ArticleResponseDetails', is_array($responseDetails) ? implode(', ', $responseDetails) : var_export($responseDetails, true), implode(', ', \EnumType\ArticleResponseDetails::getValidValues())), __LINE__);
        }
        $this->ResponseDetails = $responseDetails;
        return $this;
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\ArticleRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get ArticleId value
     * @return string|null
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param string $articleId
     * @return \StructType\ArticleRequest
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: string
        if (!is_null($articleId) && !is_string($articleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\ArticleRequest
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get PriceBranchId value
     * @return string|null
     */
    public function getPriceBranchId()
    {
        return $this->PriceBranchId;
    }
    /**
     * Set PriceBranchId value
     * @param string $priceBranchId
     * @return \StructType\ArticleRequest
     */
    public function setPriceBranchId($priceBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($priceBranchId) && !is_string($priceBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceBranchId, true), gettype($priceBranchId)), __LINE__);
        }
        $this->PriceBranchId = $priceBranchId;
        return $this;
    }
}
