<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressBook StructType
 * @subpackage Structs
 */
class AddressBook extends EntityContractBase
{
    /**
     * The DefaultAddressIdBilling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultAddressIdBilling;
    /**
     * The DefaultAddressIdShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultAddressIdShipping;
    /**
     * The DefaultAddressIdCorrespondence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultAddressIdCorrespondence;
    /**
     * The PreferredCommChannelId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreferredCommChannelId;
    /**
     * The DefaultCommChannelIdPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultCommChannelIdPhone;
    /**
     * The DefaultCommChannelIdEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultCommChannelIdEmail;
    /**
     * The DefaultCommChannelIdChat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultCommChannelIdChat;
    /**
     * Constructor method for AddressBook
     * @uses AddressBook::setDefaultAddressIdBilling()
     * @uses AddressBook::setDefaultAddressIdShipping()
     * @uses AddressBook::setDefaultAddressIdCorrespondence()
     * @uses AddressBook::setPreferredCommChannelId()
     * @uses AddressBook::setDefaultCommChannelIdPhone()
     * @uses AddressBook::setDefaultCommChannelIdEmail()
     * @uses AddressBook::setDefaultCommChannelIdChat()
     * @param string $defaultAddressIdBilling
     * @param string $defaultAddressIdShipping
     * @param string $defaultAddressIdCorrespondence
     * @param string $preferredCommChannelId
     * @param string $defaultCommChannelIdPhone
     * @param string $defaultCommChannelIdEmail
     * @param string $defaultCommChannelIdChat
     */
    public function __construct($defaultAddressIdBilling = null, $defaultAddressIdShipping = null, $defaultAddressIdCorrespondence = null, $preferredCommChannelId = null, $defaultCommChannelIdPhone = null, $defaultCommChannelIdEmail = null, $defaultCommChannelIdChat = null)
    {
        $this
            ->setDefaultAddressIdBilling($defaultAddressIdBilling)
            ->setDefaultAddressIdShipping($defaultAddressIdShipping)
            ->setDefaultAddressIdCorrespondence($defaultAddressIdCorrespondence)
            ->setPreferredCommChannelId($preferredCommChannelId)
            ->setDefaultCommChannelIdPhone($defaultCommChannelIdPhone)
            ->setDefaultCommChannelIdEmail($defaultCommChannelIdEmail)
            ->setDefaultCommChannelIdChat($defaultCommChannelIdChat);
    }
    /**
     * Get DefaultAddressIdBilling value
     * @return string|null
     */
    public function getDefaultAddressIdBilling()
    {
        return $this->DefaultAddressIdBilling;
    }
    /**
     * Set DefaultAddressIdBilling value
     * @param string $defaultAddressIdBilling
     * @return \StructType\AddressBook
     */
    public function setDefaultAddressIdBilling($defaultAddressIdBilling = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddressIdBilling) && !is_string($defaultAddressIdBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddressIdBilling, true), gettype($defaultAddressIdBilling)), __LINE__);
        }
        $this->DefaultAddressIdBilling = $defaultAddressIdBilling;
        return $this;
    }
    /**
     * Get DefaultAddressIdShipping value
     * @return string|null
     */
    public function getDefaultAddressIdShipping()
    {
        return $this->DefaultAddressIdShipping;
    }
    /**
     * Set DefaultAddressIdShipping value
     * @param string $defaultAddressIdShipping
     * @return \StructType\AddressBook
     */
    public function setDefaultAddressIdShipping($defaultAddressIdShipping = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddressIdShipping) && !is_string($defaultAddressIdShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddressIdShipping, true), gettype($defaultAddressIdShipping)), __LINE__);
        }
        $this->DefaultAddressIdShipping = $defaultAddressIdShipping;
        return $this;
    }
    /**
     * Get DefaultAddressIdCorrespondence value
     * @return string|null
     */
    public function getDefaultAddressIdCorrespondence()
    {
        return $this->DefaultAddressIdCorrespondence;
    }
    /**
     * Set DefaultAddressIdCorrespondence value
     * @param string $defaultAddressIdCorrespondence
     * @return \StructType\AddressBook
     */
    public function setDefaultAddressIdCorrespondence($defaultAddressIdCorrespondence = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddressIdCorrespondence) && !is_string($defaultAddressIdCorrespondence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddressIdCorrespondence, true), gettype($defaultAddressIdCorrespondence)), __LINE__);
        }
        $this->DefaultAddressIdCorrespondence = $defaultAddressIdCorrespondence;
        return $this;
    }
    /**
     * Get PreferredCommChannelId value
     * @return string|null
     */
    public function getPreferredCommChannelId()
    {
        return $this->PreferredCommChannelId;
    }
    /**
     * Set PreferredCommChannelId value
     * @param string $preferredCommChannelId
     * @return \StructType\AddressBook
     */
    public function setPreferredCommChannelId($preferredCommChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCommChannelId) && !is_string($preferredCommChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCommChannelId, true), gettype($preferredCommChannelId)), __LINE__);
        }
        $this->PreferredCommChannelId = $preferredCommChannelId;
        return $this;
    }
    /**
     * Get DefaultCommChannelIdPhone value
     * @return string|null
     */
    public function getDefaultCommChannelIdPhone()
    {
        return $this->DefaultCommChannelIdPhone;
    }
    /**
     * Set DefaultCommChannelIdPhone value
     * @param string $defaultCommChannelIdPhone
     * @return \StructType\AddressBook
     */
    public function setDefaultCommChannelIdPhone($defaultCommChannelIdPhone = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCommChannelIdPhone) && !is_string($defaultCommChannelIdPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCommChannelIdPhone, true), gettype($defaultCommChannelIdPhone)), __LINE__);
        }
        $this->DefaultCommChannelIdPhone = $defaultCommChannelIdPhone;
        return $this;
    }
    /**
     * Get DefaultCommChannelIdEmail value
     * @return string|null
     */
    public function getDefaultCommChannelIdEmail()
    {
        return $this->DefaultCommChannelIdEmail;
    }
    /**
     * Set DefaultCommChannelIdEmail value
     * @param string $defaultCommChannelIdEmail
     * @return \StructType\AddressBook
     */
    public function setDefaultCommChannelIdEmail($defaultCommChannelIdEmail = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCommChannelIdEmail) && !is_string($defaultCommChannelIdEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCommChannelIdEmail, true), gettype($defaultCommChannelIdEmail)), __LINE__);
        }
        $this->DefaultCommChannelIdEmail = $defaultCommChannelIdEmail;
        return $this;
    }
    /**
     * Get DefaultCommChannelIdChat value
     * @return string|null
     */
    public function getDefaultCommChannelIdChat()
    {
        return $this->DefaultCommChannelIdChat;
    }
    /**
     * Set DefaultCommChannelIdChat value
     * @param string $defaultCommChannelIdChat
     * @return \StructType\AddressBook
     */
    public function setDefaultCommChannelIdChat($defaultCommChannelIdChat = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCommChannelIdChat) && !is_string($defaultCommChannelIdChat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCommChannelIdChat, true), gettype($defaultCommChannelIdChat)), __LINE__);
        }
        $this->DefaultCommChannelIdChat = $defaultCommChannelIdChat;
        return $this;
    }
}
