<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCostDefinition StructType
 * @subpackage Structs
 */
class AdditionalCostDefinition extends BaseContract_ID
{
    /**
     * The DefaultValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DefaultValue;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * Constructor method for AdditionalCostDefinition
     * @uses AdditionalCostDefinition::setDefaultValue()
     * @uses AdditionalCostDefinition::setDescription()
     * @uses AdditionalCostDefinition::setCurrencyISO()
     * @param float $defaultValue
     * @param string $description
     * @param string $currencyISO
     */
    public function __construct($defaultValue = null, $description = null, $currencyISO = null)
    {
        $this
            ->setDefaultValue($defaultValue)
            ->setDescription($description)
            ->setCurrencyISO($currencyISO);
    }
    /**
     * Get DefaultValue value
     * @return float
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param float $defaultValue
     * @return \StructType\AdditionalCostDefinition
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: float
        if (!is_null($defaultValue) && !(is_float($defaultValue) || is_numeric($defaultValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AdditionalCostDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\AdditionalCostDefinition
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
}
