<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receive ServiceType
 * @subpackage Services
 */
class Receive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReceiveIbt
     * Meta information extracted from the WSDL
     * - documentation: Receives the IBT with the quantities sent.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReceiveIbt $parameters
     * @return \StructType\ReceiveIbtResponse|bool
     */
    public function ReceiveIbt(\StructType\ReceiveIbt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReceiveIbt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReceiveIbtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
