<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FindArticleByOid
     * Meta information extracted from the WSDL
     * - documentation: Finds a single Article object by given Article Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindArticleByOid $parameters
     * @return \StructType\FindArticleByOidResponse|bool
     */
    public function FindArticleByOid(\StructType\FindArticleByOid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindArticleByOid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindArticleByOidWithCharcteristics
     * Meta information extracted from the WSDL
     * - documentation: Finds a single Article object by given Article Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindArticleByOidWithCharcteristics $parameters
     * @return \StructType\FindArticleByOidWithCharcteristicsResponse|bool
     */
    public function FindArticleByOidWithCharcteristics(\StructType\FindArticleByOidWithCharcteristics $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindArticleByOidWithCharcteristics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindArticleByEanOid
     * Meta information extracted from the WSDL
     * - documentation: Finds a single Article object by given EAN Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindArticleByEanOid $parameters
     * @return \StructType\FindArticleByEanOidResponse|bool
     */
    public function FindArticleByEanOid(\StructType\FindArticleByEanOid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindArticleByEanOid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * FindArticleByEanOidWithCharcteristics
     * Meta information extracted from the WSDL
     * - documentation: Finds a single Article object by given Article Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindArticleByEanOidWithCharcteristics $parameters
     * @return \StructType\FindArticleByEanOidWithCharcteristicsResponse|bool
     */
    public function FindArticleByEanOidWithCharcteristics(\StructType\FindArticleByEanOidWithCharcteristics $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindArticleByEanOidWithCharcteristics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindCustomerByOid
     * Meta information extracted from the WSDL
     * - documentation: Finds a single Customer object by given customer Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomerByOid $parameters
     * @return \StructType\FindCustomerByOidResponse|bool
     */
    public function FindCustomerByOid(\StructType\FindCustomerByOid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindCustomerByOid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindCustomersByParameter
     * Meta information extracted from the WSDL
     * - documentation: Finds a Customer objects by given parameter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCustomersByParameter $parameters
     * @return \StructType\FindCustomersByParameterResponse|bool
     */
    public function FindCustomersByParameter(\StructType\FindCustomersByParameter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindCustomersByParameter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindStockByArticleOid
     * Meta information extracted from the WSDL
     * - documentation: Finds a single group of StockInfo objects by given Article Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindStockByArticleOid $parameters
     * @return \StructType\FindStockByArticleOidResponse|bool
     */
    public function FindStockByArticleOid(\StructType\FindStockByArticleOid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindStockByArticleOid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindStockByEanOid
     * Meta information extracted from the WSDL
     * - documentation: Finds a single group of StockInfo objects by given EAN Oid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindStockByEanOid $parameters
     * @return \StructType\FindStockByEanOidResponse|bool
     */
    public function FindStockByEanOid(\StructType\FindStockByEanOid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindStockByEanOid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindArticleByEanOidResponse|\StructType\FindArticleByEanOidWithCharcteristicsResponse|\StructType\FindArticleByOidResponse|\StructType\FindArticleByOidWithCharcteristicsResponse|\StructType\FindCustomerByOidResponse|\StructType\FindCustomersByParameterResponse|\StructType\FindStockByArticleOidResponse|\StructType\FindStockByEanOidResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
