<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SpecialPayment EnumType
 * @subpackage Enumerations
 */
class SpecialPayment extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NO'
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Constant for value 'GIFT_VOUCHER'
     * @return string 'GIFT_VOUCHER'
     */
    const VALUE_GIFT_VOUCHER = 'GIFT_VOUCHER';
    /**
     * Constant for value 'ADVANCE'
     * @return string 'ADVANCE'
     */
    const VALUE_ADVANCE = 'ADVANCE';
    /**
     * Constant for value 'SALE_ON_CREDIT'
     * @return string 'SALE_ON_CREDIT'
     */
    const VALUE_SALE_ON_CREDIT = 'SALE_ON_CREDIT';
    /**
     * Constant for value 'CREDIT_ADVICE'
     * @return string 'CREDIT_ADVICE'
     */
    const VALUE_CREDIT_ADVICE = 'CREDIT_ADVICE';
    /**
     * Constant for value 'EC_DEBIT_ADVICE'
     * @return string 'EC_DEBIT_ADVICE'
     */
    const VALUE_EC_DEBIT_ADVICE = 'EC_DEBIT_ADVICE';
    /**
     * Constant for value 'INTER_BRANCH_TRANSFER'
     * @return string 'INTER_BRANCH_TRANSFER'
     */
    const VALUE_INTER_BRANCH_TRANSFER = 'INTER_BRANCH_TRANSFER';
    /**
     * Constant for value 'INVOICE'
     * @return string 'INVOICE'
     */
    const VALUE_INVOICE = 'INVOICE';
    /**
     * Constant for value 'SUPPLIER_RETURN'
     * @return string 'SUPPLIER_RETURN'
     */
    const VALUE_SUPPLIER_RETURN = 'SUPPLIER_RETURN';
    /**
     * Constant for value 'SELECTION'
     * @return string 'SELECTION'
     */
    const VALUE_SELECTION = 'SELECTION';
    /**
     * Constant for value 'INPAYMENT_EXPENSE'
     * @return string 'INPAYMENT_EXPENSE'
     */
    const VALUE_INPAYMENT_EXPENSE = 'INPAYMENT_EXPENSE';
    /**
     * Constant for value 'CREDIT_CARD_AUTOMATIC'
     * @return string 'CREDIT_CARD_AUTOMATIC'
     */
    const VALUE_CREDIT_CARD_AUTOMATIC = 'CREDIT_CARD_AUTOMATIC';
    /**
     * Constant for value 'EC_DEBIT_ADVICE_SP_I'
     * @return string 'EC_DEBIT_ADVICE_SP_I'
     */
    const VALUE_EC_DEBIT_ADVICE_SP_I = 'EC_DEBIT_ADVICE_SP_I';
    /**
     * Constant for value 'CUSTOMER_CARD'
     * @return string 'CUSTOMER_CARD'
     */
    const VALUE_CUSTOMER_CARD = 'CUSTOMER_CARD';
    /**
     * Constant for value 'EC_CARD_SP_II'
     * @return string 'EC_CARD_SP_II'
     */
    const VALUE_EC_CARD_SP_II = 'EC_CARD_SP_II';
    /**
     * Constant for value 'RECEIPT_REPEAT_SP_II'
     * @return string 'RECEIPT_REPEAT_SP_II'
     */
    const VALUE_RECEIPT_REPEAT_SP_II = 'RECEIPT_REPEAT_SP_II';
    /**
     * Constant for value 'RESERVE_SUM_AMOUNT'
     * @return string 'RESERVE_SUM_AMOUNT'
     */
    const VALUE_RESERVE_SUM_AMOUNT = 'RESERVE_SUM_AMOUNT';
    /**
     * Constant for value 'RESERVE_REMAIN_AMOUNT'
     * @return string 'RESERVE_REMAIN_AMOUNT'
     */
    const VALUE_RESERVE_REMAIN_AMOUNT = 'RESERVE_REMAIN_AMOUNT';
    /**
     * Constant for value 'ADVANCE_RESERVE'
     * @return string 'ADVANCE_RESERVE'
     */
    const VALUE_ADVANCE_RESERVE = 'ADVANCE_RESERVE';
    /**
     * Constant for value 'RECEIPT_REPEAT_TCS'
     * @return string 'RECEIPT_REPEAT_TCS'
     */
    const VALUE_RECEIPT_REPEAT_TCS = 'RECEIPT_REPEAT_TCS';
    /**
     * Return allowed values
     * @uses self::VALUE_NO
     * @uses self::VALUE_GIFT_VOUCHER
     * @uses self::VALUE_ADVANCE
     * @uses self::VALUE_SALE_ON_CREDIT
     * @uses self::VALUE_CREDIT_ADVICE
     * @uses self::VALUE_EC_DEBIT_ADVICE
     * @uses self::VALUE_INTER_BRANCH_TRANSFER
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_SUPPLIER_RETURN
     * @uses self::VALUE_SELECTION
     * @uses self::VALUE_INPAYMENT_EXPENSE
     * @uses self::VALUE_CREDIT_CARD_AUTOMATIC
     * @uses self::VALUE_EC_DEBIT_ADVICE_SP_I
     * @uses self::VALUE_CUSTOMER_CARD
     * @uses self::VALUE_EC_CARD_SP_II
     * @uses self::VALUE_RECEIPT_REPEAT_SP_II
     * @uses self::VALUE_RESERVE_SUM_AMOUNT
     * @uses self::VALUE_RESERVE_REMAIN_AMOUNT
     * @uses self::VALUE_ADVANCE_RESERVE
     * @uses self::VALUE_RECEIPT_REPEAT_TCS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO,
            self::VALUE_GIFT_VOUCHER,
            self::VALUE_ADVANCE,
            self::VALUE_SALE_ON_CREDIT,
            self::VALUE_CREDIT_ADVICE,
            self::VALUE_EC_DEBIT_ADVICE,
            self::VALUE_INTER_BRANCH_TRANSFER,
            self::VALUE_INVOICE,
            self::VALUE_SUPPLIER_RETURN,
            self::VALUE_SELECTION,
            self::VALUE_INPAYMENT_EXPENSE,
            self::VALUE_CREDIT_CARD_AUTOMATIC,
            self::VALUE_EC_DEBIT_ADVICE_SP_I,
            self::VALUE_CUSTOMER_CARD,
            self::VALUE_EC_CARD_SP_II,
            self::VALUE_RECEIPT_REPEAT_SP_II,
            self::VALUE_RESERVE_SUM_AMOUNT,
            self::VALUE_RESERVE_REMAIN_AMOUNT,
            self::VALUE_ADVANCE_RESERVE,
            self::VALUE_RECEIPT_REPEAT_TCS,
        );
    }
}
